/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import java.net.URL;
import org.exist.source.ClassLoaderSource;
import org.exist.source.CocoonSource;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.source.URLSource;
import org.exist.xmldb.XmldbURI;

public class XACMLSource {
    private static final String FILE_PROTOCOL = "file";
    private final String type;
    private final String key;

    private XACMLSource() {
        this(null, null);
    }

    private XACMLSource(String type, String key) {
        this.type = type;
        this.key = key;
    }

    public static XACMLSource getInstance(Class source) {
        if (source == null) {
            throw new NullPointerException("Source class cannot be null");
        }
        return XACMLSource.getInstance(source.getName());
    }

    public static XACMLSource getInstance(String sourceClassName) {
        if (sourceClassName == null) {
            throw new NullPointerException("Source class name cannot be null");
        }
        return new XACMLSource("Class", sourceClassName);
    }

    public static XACMLSource getInstance(Source source) {
        if (source == null) {
            throw new NullPointerException("Source cannot be null");
        }
        if (source instanceof FileSource) {
            return new XACMLSource("File", ((FileSource)source).getFilePath());
        }
        if (source instanceof URLSource) {
            URL url = ((URLSource)source).getURL();
            String protocol = url.getProtocol();
            String host = url.getHost();
            if (protocol.equals(FILE_PROTOCOL) && (host == null || host.length() == 0 || host.equals("localhost") || host.equals("127.0.0.1"))) {
                String path = url.getFile();
                return new XACMLSource("File", path);
            }
            String key = url.toExternalForm();
            String type = source instanceof ClassLoaderSource ? "Classloader" : "URL";
            return new XACMLSource(type, key);
        }
        if (source instanceof StringSource) {
            return new XACMLSource("String", "String");
        }
        if (source instanceof CocoonSource) {
            String key = ((CocoonSource)source).getWrappedSource().getURI();
            return new XACMLSource("Cocoon", key);
        }
        if (source instanceof DBSource) {
            XmldbURI key = ((DBSource)source).getDocumentPath();
            return new XACMLSource("Database", key.toString());
        }
        throw new IllegalArgumentException("Unsupported source type '" + source.getClass().getName() + "'");
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String createId() {
        return this.type.equals("String") ? "[constructed]" : this.type + ": '" + this.key + "'";
    }
}

