/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.apache.log4j.Logger;
import org.exist.collections.CollectionCache;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Cache;
import org.exist.util.Configuration;

public class CollectionCacheManager
implements CacheManager {
    private static final Logger LOG = Logger.getLogger((Class)CollectionCacheManager.class);
    public static final String CACHE_SIZE_ATTRIBUTE = "collectionCache";
    public static final String PROPERTY_CACHE_SIZE = "db-connection.collection-cache-mem";
    private static final int DEFAULT_CACHE_SIZE = 8;
    private int maxCacheSize;
    private CollectionCache collectionCache;

    public CollectionCacheManager(Configuration config, CollectionCache cache) {
        int cacheSize = config.getInteger(PROPERTY_CACHE_SIZE);
        if (cacheSize < 0) {
            cacheSize = 8;
        }
        this.maxCacheSize = cacheSize * 1024 * 1024;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("collection collectionCache will be using " + this.maxCacheSize + " bytes max."));
        }
        this.collectionCache = cache;
        this.collectionCache.setCacheManager(this);
    }

    public void registerCache(Cache cache) {
    }

    public void deregisterCache(Cache cache) {
        this.collectionCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestMem(Cache cache) {
        int realSize = this.collectionCache.getRealSize();
        if (realSize < this.maxCacheSize) {
            CollectionCacheManager collectionCacheManager = this;
            synchronized (collectionCacheManager) {
                int newCacheSize = (int)((double)this.collectionCache.getBuffers() * this.collectionCache.getGrowthFactor());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Growing cache " + this.collectionCache.getFileName() + " (a " + this.collectionCache.getClass().getName() + ") from " + this.collectionCache.getBuffers() + " to " + newCacheSize + ". Current memory usage = " + realSize));
                }
                this.collectionCache.resize(newCacheSize);
                return newCacheSize;
            }
        }
        LOG.debug((Object)("Cache has reached max. size: " + realSize));
        return -1;
    }

    public void checkCaches() {
    }

    public void checkDistribution() {
    }

    public long getMaxTotal() {
        return this.maxCacheSize;
    }

    public long getMaxSingle() {
        return this.maxCacheSize;
    }

    public long getCurrentSize() {
        return this.collectionCache.getRealSize();
    }
}

