/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Map;
import org.exist.storage.NodePath;
import org.exist.storage.RangeIndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Type;

public class GeneralRangeIndexSpec
extends RangeIndexSpec {
    private NodePath path;

    public GeneralRangeIndexSpec(Map namespaces, String pathStr, String typeStr) throws DatabaseConfigurationException {
        if (pathStr.length() == 0) {
            throw new DatabaseConfigurationException("The path attribute is required in index.create");
        }
        this.path = new NodePath(namespaces, pathStr, false);
        try {
            this.type = Type.getType(typeStr);
        }
        catch (XPathException e) {
            throw new DatabaseConfigurationException("Unknown type: " + typeStr);
        }
    }

    public NodePath getPath() {
        return this.path;
    }

    protected boolean matches(NodePath otherPath) {
        return this.path.match(otherPath);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("General range index\n");
        result.append("\ttype : ").append(Type.getTypeName(this.type)).append('\n');
        result.append("\tpath : ").append(this.path.toString()).append('\n');
        result.append("\thas full text index : ").append(GeneralRangeIndexSpec.hasFulltextIndex(this.type)).append('\n');
        result.append("\thas mixed content : ").append(GeneralRangeIndexSpec.hasMixedContent(this.type)).append('\n');
        result.append("\thas Qname index : ").append(GeneralRangeIndexSpec.hasQNameIndex(this.type)).append('\n');
        result.append("\thas Qname or value index : ").append(GeneralRangeIndexSpec.hasQNameOrValueIndex(this.type)).append('\n');
        result.append("\thas range index : ").append(GeneralRangeIndexSpec.hasRangeIndex(this.type)).append('\n');
        return result.toString();
    }
}

