/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.ByDocumentIterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtNodeSet;
import org.exist.dom.NewArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.numbering.DLN;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementIndex;
import org.exist.storage.ElementValue;
import org.exist.storage.NodePath;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.ProgressIndicator;
import org.exist.util.ReadOnlyException;
import org.exist.xquery.DescendantSelector;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;

public class NativeElementIndex
extends ElementIndex
implements ContentLoadingObserver {
    public static final String FILE_NAME = "elements.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.elements";
    public static final double DEFAULT_STRUCTURAL_CACHE_GROWTH = 1.25;
    public static final double DEFAULT_STRUCTURAL_KEY_THRESHOLD = 0.01;
    public static final double DEFAULT_STRUCTURAL_VALUE_THRESHOLD = 0.04;
    private static final byte ENTRIES_ORDERED = 0;
    private static final byte ENTRIES_UNORDERED = 1;
    public static int OFFSET_COLLECTION_ID = 0;
    public static int OFFSET_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
    public static int OFFSET_SYMBOL = OFFSET_TYPE + ElementValue.LENGTH_TYPE;
    public static int OFFSET_NSSYMBOL = OFFSET_SYMBOL + SymbolTable.LENGTH_LOCAL_NAME;
    private static Logger LOG = Logger.getLogger((String)NativeElementIndex.class.getName());
    protected BFile dbNodes;
    protected Configuration config;
    private VariableByteOutputStream os = new VariableByteOutputStream();

    public NativeElementIndex(DBBroker broker, byte id, String dataDir, Configuration config) throws DBException {
        super(broker);
        this.config = config;
        double cacheGrowth = 1.25;
        double cacheKeyThresdhold = 0.01;
        double cacheValueThresHold = 0.04;
        BFile nativeFile = (BFile)config.getProperty(this.getConfigKeyForFile());
        if (nativeFile == null) {
            File file = new File(dataDir + File.separatorChar + this.getFileName());
            LOG.debug((Object)("Creating '" + file.getName() + "'..."));
            nativeFile = new BFile(broker.getBrokerPool(), id, false, file, broker.getBrokerPool().getCacheManager(), cacheGrowth, cacheKeyThresdhold, cacheValueThresHold);
            config.setProperty(this.getConfigKeyForFile(), nativeFile);
        }
        this.dbNodes = nativeFile;
        broker.addContentLoadingObserver(this.getInstance());
    }

    public String getFileName() {
        return FILE_NAME;
    }

    public String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    public NativeElementIndex getInstance() {
        return this;
    }

    public void addNode(QName qname, NodeProxy proxy) {
        if (this.doc.getDocId() != proxy.getDocument().getDocId()) {
            throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + proxy.getDocument().getDocId() + "') differ !");
        }
        ArrayList<NodeProxy> buf = (ArrayList<NodeProxy>)this.pending.get(qname);
        if (buf == null) {
            buf = new ArrayList<NodeProxy>(50);
            this.pending.put(qname, buf);
        }
        buf.add(proxy);
    }

    public void storeAttribute(AttrImpl node, NodePath currentPath, int indexingHint, RangeIndexSpec spec, boolean remove) {
    }

    public void storeText(TextImpl node, NodePath currentPath, int indexingHint) {
    }

    public void removeNode(StoredNode node, NodePath currentPath, String content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Lock lock = this.dbNodes.getLock();
        try {
            lock.acquire(1);
            this.dbNodes.flush();
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
        }
        catch (DBException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.pending.size() == 0) {
            return;
        }
        ProgressIndicator progress = new ProgressIndicator(this.pending.size(), 5);
        int collectionId = this.doc.getCollection().getId();
        Lock lock = this.dbNodes.getLock();
        int count = 0;
        Iterator i = this.pending.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            QName qname = (QName)entry.getKey();
            ArrayList gids = (ArrayList)entry.getValue();
            int gidsCount = gids.size();
            FastQSort.sort(gids, 0, gidsCount - 1);
            this.os.clear();
            this.os.writeInt(this.doc.getDocId());
            this.os.writeByte(this.inUpdateMode ? (byte)1 : 0);
            this.os.writeInt(gidsCount);
            int lenOffset = this.os.position();
            this.os.writeFixedInt(0);
            NodeId previous = null;
            for (int j = 0; j < gidsCount; ++j) {
                NodeProxy storedNode = (NodeProxy)gids.get(j);
                if (this.doc.getDocId() != storedNode.getDocument().getDocId()) {
                    throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + storedNode.getDocument().getDocId() + "') differ !");
                }
                try {
                    previous = storedNode.getNodeId().write(previous, this.os);
                }
                catch (IOException e) {
                    LOG.warn((Object)("IO error while writing structural index: " + e.getMessage()), (Throwable)e);
                }
                StorageAddress.write(storedNode.getInternalAddress(), this.os);
            }
            this.broker.getBrokerPool().getNodeFactory().writeEndOfDocument(this.os);
            this.os.writeFixedInt(lenOffset, this.os.position() - lenOffset - 4);
            try {
                lock.acquire(1);
                Value key = this.computeKey(collectionId, qname);
                if (this.dbNodes.append(key, this.os.data()) == -1L) {
                    LOG.error((Object)("Could not put index data for node '" + qname + "'"));
                }
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (ReadOnlyException e) {
                LOG.warn((Object)("Read-only error on '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
                return;
            }
            finally {
                lock.release(1);
                this.os.clear();
            }
            progress.setValue(count);
            if (progress.changed()) {
                this.setChanged();
                this.notifyObservers(progress);
            }
            ++count;
        }
        progress.finish();
        this.setChanged();
        this.notifyObservers(progress);
        this.pending.clear();
        this.inUpdateMode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        if (this.pending.size() == 0) {
            return;
        }
        int collectionId = this.doc.getCollection().getId();
        Lock lock = this.dbNodes.getLock();
        Iterator i = this.pending.entrySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                this.pending.clear();
                return;
            }
            Map.Entry entry = i.next();
            ArrayList storedGIDList = (ArrayList)entry.getValue();
            QName qname = (QName)entry.getKey();
            Value key = this.computeKey(collectionId, qname);
            ArrayList<NodeProxy> newGIDList = new ArrayList<NodeProxy>();
            this.os.clear();
            try {
                lock.acquire(1);
                Value value = this.dbNodes.get(key);
                if (value != null) {
                    VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                    try {
                        while (is.available() > 0) {
                            int storedDocId = is.readInt();
                            byte isOrdered = is.readByte();
                            int gidsCount = is.readInt();
                            int size = is.readFixedInt();
                            if (storedDocId != this.doc.getDocId()) {
                                this.os.writeInt(storedDocId);
                                this.os.writeByte(isOrdered);
                                this.os.writeInt(gidsCount);
                                this.os.writeFixedInt(size);
                                try {
                                    is.copyRaw(this.os, size);
                                    continue;
                                }
                                catch (EOFException e) {
                                    LOG.error((Object)e.getMessage(), (Throwable)e);
                                    continue;
                                }
                            }
                            NodeId previous = null;
                            for (int j = 0; j < gidsCount; ++j) {
                                NodeId nodeId;
                                previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                                long address = StorageAddress.read(is);
                                if (NativeElementIndex.containsNode(storedGIDList, nodeId)) continue;
                                newGIDList.add(new NodeProxy(this.doc, nodeId, address));
                            }
                            this.broker.getBrokerPool().getNodeFactory().createFromStream(NodeId.ROOT_NODE, is);
                        }
                    }
                    catch (EOFException e) {
                        LOG.warn((Object)("REPORT ME " + e.getMessage()), (Throwable)e);
                    }
                    if (newGIDList.size() > 0) {
                        int gidsCount = newGIDList.size();
                        FastQSort.sort(newGIDList, 0, gidsCount - 1);
                        this.os.writeInt(this.doc.getDocId());
                        this.os.writeByte((byte)0);
                        this.os.writeInt(gidsCount);
                        int lenOffset = this.os.position();
                        this.os.writeFixedInt(0);
                        NodeId previous = null;
                        for (int j = 0; j < gidsCount; ++j) {
                            NodeProxy storedNode = (NodeProxy)newGIDList.get(j);
                            if (this.doc.getDocId() != storedNode.getDocument().getDocId()) {
                                throw new IllegalArgumentException("Document id ('" + this.doc.getDocId() + "') and proxy id ('" + storedNode.getDocument().getDocId() + "') differ !");
                            }
                            try {
                                previous = storedNode.getNodeId().write(previous, this.os);
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("IO error while writing structural index: " + e.getMessage()), (Throwable)e);
                            }
                            StorageAddress.write(storedNode.getInternalAddress(), this.os);
                        }
                        this.broker.getBrokerPool().getNodeFactory().writeEndOfDocument(this.os);
                        this.os.writeFixedInt(lenOffset, this.os.position() - lenOffset - 4);
                    }
                }
                if (value == null) {
                    if (this.dbNodes.put(key, this.os.data()) != -1L) continue;
                    LOG.error((Object)("Could not put index data for node '" + qname + "'"));
                    continue;
                }
                if (this.dbNodes.update(value.getAddress(), key, this.os.data()) != -1L) continue;
                LOG.error((Object)("Could not put index data for node '" + qname + "'"));
                continue;
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
                continue;
            }
            catch (ReadOnlyException e) {
                LOG.warn((Object)("Read-only error on '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                lock.release(1);
                this.os.clear();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Collection collection) {
        ElementValue ref = new ElementValue(collection.getId());
        IndexQuery query = new IndexQuery(7, (Value)ref);
        Lock lock = this.dbNodes.getLock();
        try {
            lock.acquire(1);
            this.dbNodes.removeAll(null, query);
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(DocumentImpl document) throws ReadOnlyException {
        int collectionId = document.getCollection().getId();
        ElementValue ref = new ElementValue(collectionId);
        IndexQuery query = new IndexQuery(7, (Value)ref);
        Lock lock = this.dbNodes.getLock();
        try {
            lock.acquire(1);
            ArrayList elements = this.dbNodes.findKeys(query);
            for (int i = 0; i < elements.size(); ++i) {
                boolean changed = false;
                Value key = (Value)elements.get(i);
                VariableByteInput is = this.dbNodes.getAsStream(key);
                if (is == null) continue;
                this.os.clear();
                try {
                    while (is.available() > 0) {
                        int storedDocId = is.readInt();
                        byte ordered = is.readByte();
                        int gidsCount = is.readInt();
                        int size = is.readFixedInt();
                        if (storedDocId != document.getDocId()) {
                            this.os.writeInt(storedDocId);
                            this.os.writeByte(ordered);
                            this.os.writeInt(gidsCount);
                            this.os.writeFixedInt(size);
                            is.copyRaw(this.os, size);
                            continue;
                        }
                        changed = true;
                        is.skipBytes(size);
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
                if (!changed) continue;
                if (this.os.data().size() == 0) {
                    this.dbNodes.remove(key);
                    continue;
                }
                if (this.dbNodes.put(key, this.os.data()) != -1L) continue;
                LOG.error((Object)("Could not put index data for value '" + ref + "'"));
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
            this.os.clear();
        }
        if (this.os.size() > 512000) {
            this.os = new VariableByteOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeSet findElementsByTagName(byte type, DocumentSet docs, QName qname, NodeSelector selector) {
        short nodeType = this.getIndexType(type);
        NewArrayNodeSet result = new NewArrayNodeSet(docs.getLength(), 256);
        Lock lock = this.dbNodes.getLock();
        boolean sameDocSet = true;
        boolean descendantAxis = selector instanceof DescendantSelector;
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            int collectionId = collection.getId();
            Value key = this.computeTypedKey(type, collectionId, qname);
            try {
                lock.acquire(0);
                VariableByteInput is = this.dbNodes.getAsStream(key);
                if (is == null) {
                    sameDocSet = false;
                    continue;
                }
                while (is.available() > 0) {
                    NodeId nodeId;
                    int storedDocId = is.readInt();
                    byte ordered = is.readByte();
                    int gidsCount = is.readInt();
                    int size = is.readFixedInt();
                    DocumentImpl storedDocument = docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes(size);
                        continue;
                    }
                    NodeId previous = null;
                    for (int k = 0; k < gidsCount; ++k) {
                        previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        if (selector == null) {
                            long address = StorageAddress.read(is);
                            NodeProxy storedNode = new NodeProxy(storedDocument, nodeId, nodeType, address);
                            result.add(storedNode, gidsCount);
                            continue;
                        }
                        NodeProxy storedNode = selector.match(storedDocument, nodeId);
                        if (storedNode != null) {
                            long address = StorageAddress.read(is);
                            storedNode.setInternalAddress(address);
                            storedNode.setNodeType(nodeType);
                            result.add(storedNode, gidsCount);
                            continue;
                        }
                        is.skip(3);
                        sameDocSet = false;
                    }
                    nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(NodeId.ROOT_NODE, is);
                    result.setSorted(storedDocument, ordered == 0 && !descendantAxis);
                }
            }
            catch (EOFException e) {
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        if (sameDocSet) {
            result.setDocumentSet(docs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeSet findDescendantsByTagName(byte type, QName qname, int axis, DocumentSet docs, ExtNodeSet contextSet, int contextId) {
        short nodeType = this.getIndexType(type);
        ByDocumentIterator citer = contextSet.iterateByDocument();
        NewArrayNodeSet result = new NewArrayNodeSet(docs.getLength(), 256);
        Lock lock = this.dbNodes.getLock();
        boolean sameDocSet = true;
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            int collectionId = collection.getId();
            Value key = this.computeTypedKey(type, collectionId, qname);
            try {
                lock.acquire(0);
                VariableByteInput is = this.dbNodes.getAsStream(key);
                if (is == null) {
                    sameDocSet = false;
                    continue;
                }
                int lastDocId = -1;
                NodeProxy ancestor = null;
                while (is.available() > 0) {
                    NodeProxy lastAncestor;
                    block31: {
                        NodeId nodeId;
                        long prevPosition;
                        int storedDocId = is.readInt();
                        byte ordered = is.readByte();
                        int gidsCount = is.readInt();
                        int size = is.readFixedInt();
                        DocumentImpl storedDocument = docs.getDoc(storedDocId);
                        if (storedDocument == null) {
                            is.skipBytes(size);
                            continue;
                        }
                        if (storedDocId != lastDocId || ordered == 1) {
                            citer.nextDocument(storedDocument);
                            lastDocId = storedDocId;
                            ancestor = citer.nextNode();
                        }
                        if (ancestor == null || gidsCount == 0) {
                            is.skipBytes(size);
                            continue;
                        }
                        NodeId ancestorId = ancestor.getNodeId();
                        long markedPosition = prevPosition = ((BFile.PageInputStream)((Object)is)).position();
                        NodeId markedId = null;
                        NodeId previousId = null;
                        lastAncestor = null;
                        previousId = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previousId, is);
                        long address = StorageAddress.read(is);
                        while (true) {
                            NodeId nextId;
                            int relation;
                            if ((relation = nodeId.computeRelation(ancestorId)) != -1) {
                                NodeProxy nextNode;
                                NodeId next;
                                if ((axis == 5 || axis == 6) && relation == 1 || axis == 7 && (relation == 2 || relation == 1) || axis == 8 || axis == 13) {
                                    NodeProxy storedNode = new NodeProxy(storedDocument, nodeId, nodeType, address);
                                    result.add(storedNode, gidsCount);
                                    if (-1 != contextId) {
                                        storedNode.deepCopyContext(ancestor, contextId);
                                    } else {
                                        storedNode.copyContext(ancestor);
                                    }
                                    storedNode.addMatches(ancestor);
                                }
                                prevPosition = ((BFile.PageInputStream)((Object)is)).position();
                                previousId = next = this.broker.getBrokerPool().getNodeFactory().createFromStream(previousId, is);
                                if (next != DLN.END_OF_DOCUMENT) {
                                    nodeId = next;
                                    address = StorageAddress.read(is);
                                    continue;
                                }
                                if (citer.hasNextNode() && (nextNode = citer.peekNode()).getNodeId().isDescendantOf(ancestorId)) {
                                    prevPosition = markedPosition;
                                    ((BFile.PageInputStream)((Object)is)).seek(markedPosition);
                                    previousId = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(markedId, is);
                                    address = StorageAddress.read(is);
                                    ancestor = citer.nextNode();
                                    ancestorId = ancestor.getNodeId();
                                    continue;
                                }
                                break block31;
                            }
                            int cmp = ancestorId.compareTo(nodeId);
                            if (cmp < 0) {
                                if (citer.hasNextNode()) {
                                    NodeProxy next = citer.nextNode();
                                    if (next.getNodeId().isDescendantOf(ancestorId)) {
                                        prevPosition = markedPosition;
                                        ((BFile.PageInputStream)((Object)is)).seek(markedPosition);
                                        previousId = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(markedId, is);
                                        address = StorageAddress.read(is);
                                    } else {
                                        markedPosition = prevPosition;
                                        markedId = nodeId;
                                    }
                                    ancestor = next;
                                    ancestorId = ancestor.getNodeId();
                                    continue;
                                }
                                while ((previousId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previousId, is)) != DLN.END_OF_DOCUMENT) {
                                    StorageAddress.read(is);
                                }
                                break block31;
                            }
                            prevPosition = ((BFile.PageInputStream)((Object)is)).position();
                            previousId = nextId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previousId, is);
                            if (nextId != DLN.END_OF_DOCUMENT) {
                                nodeId = nextId;
                                address = StorageAddress.read(is);
                                continue;
                            }
                            if (lastAncestor == null) {
                                lastAncestor = ancestor;
                            }
                            if (!citer.hasNextNode()) break block31;
                            ancestor = citer.nextNode();
                            if (!ancestor.getNodeId().isDescendantOf(ancestorId)) break;
                            prevPosition = markedPosition;
                            ((BFile.PageInputStream)((Object)is)).seek(markedPosition);
                            previousId = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(markedId, is);
                            address = StorageAddress.read(is);
                            ancestorId = ancestor.getNodeId();
                        }
                        ancestorId = ancestor.getNodeId();
                    }
                    if (lastAncestor == null) continue;
                    ancestor = lastAncestor;
                    citer.setPosition(ancestor);
                }
            }
            catch (EOFException e) {
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        if (sameDocSet) {
            result.setDocumentSet(docs);
        }
        return result;
    }

    private short getIndexType(byte type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 2;
            }
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndexedElements(Collection collection, boolean inclusive) throws PermissionDeniedException {
        User user = this.broker.getUser();
        if (!collection.getPermissions().validate(user, 4)) {
            throw new PermissionDeniedException("User '" + user.getName() + "' has no permission to read collection '" + collection.getURI() + "'");
        }
        List<Collection> collections = inclusive ? collection.getDescendants(this.broker, this.broker.getUser()) : new ArrayList<Collection>();
        collections.add(collection);
        SymbolTable symbols = this.broker.getBrokerPool().getSymbols();
        TreeMap<QName, Occurrences> map = new TreeMap<QName, Occurrences>();
        Lock lock = this.dbNodes.getLock();
        Iterator i = collections.iterator();
        while (i.hasNext()) {
            Collection storedCollection = (Collection)i.next();
            int storedCollectionId = storedCollection.getId();
            ElementValue startKey = new ElementValue(0, storedCollectionId);
            IndexQuery query = new IndexQuery(7, (Value)startKey);
            try {
                lock.acquire(0);
                ArrayList values = this.dbNodes.findEntries(query);
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    String namespace;
                    Value[] val = (Value[])j.next();
                    short sym = ByteConversion.byteToShort(val[0].getData(), OFFSET_SYMBOL);
                    short nsSymbol = ByteConversion.byteToShort(val[0].getData(), OFFSET_NSSYMBOL);
                    String name = symbols.getName(sym);
                    QName qname = new QName(name, namespace = nsSymbol == 0 ? "" : symbols.getNamespace(nsSymbol));
                    Occurrences oc = (Occurrences)map.get(qname);
                    if (oc == null) {
                        XQueryContext context = new XQueryContext(this.broker, AccessContext.INTERNAL_PREFIX_LOOKUP);
                        qname.setPrefix(context.getPrefixForURI(namespace));
                        oc = new Occurrences(qname);
                        map.put(qname, oc);
                    }
                    VariableByteArrayInput is = new VariableByteArrayInput(val[1].data(), val[1].start(), val[1].getLength());
                    try {
                        while (is.available() > 0) {
                            is.readInt();
                            is.readByte();
                            int gidsCount = is.readInt();
                            int size = is.readFixedInt();
                            is.skipBytes(size);
                            oc.addOccurrences(gidsCount);
                        }
                    }
                    catch (EOFException e) {
                        LOG.warn((Object)("REPORT ME " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.release(0);
            }
        }
        Occurrences[] result = new Occurrences[map.size()];
        return map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consistencyCheck(DocumentImpl document) throws EXistException {
        SymbolTable symbols = this.broker.getBrokerPool().getSymbols();
        int collectionId = document.getCollection().getId();
        ElementValue ref = new ElementValue(collectionId);
        IndexQuery query = new IndexQuery(7, (Value)ref);
        StringBuffer msg = new StringBuffer();
        Lock lock = this.dbNodes.getLock();
        try {
            lock.acquire(1);
            ArrayList elements = this.dbNodes.findKeys(query);
            for (int i = 0; i < elements.size(); ++i) {
                Value key = (Value)elements.get(i);
                Value value = this.dbNodes.get(key);
                short sym = ByteConversion.byteToShort(key.data(), key.start() + OFFSET_SYMBOL);
                String nodeName = symbols.getName(sym);
                msg.setLength(0);
                msg.append("Checking ").append(nodeName).append(": ");
                VariableByteArrayInput is = new VariableByteArrayInput(value.getData());
                try {
                    while (is.available() > 0) {
                        int storedDocId = is.readInt();
                        is.readByte();
                        int gidsCount = is.readInt();
                        is.readFixedInt();
                        if (storedDocId != document.getDocId()) {
                            is.skip(gidsCount * 4);
                            continue;
                        }
                        NodeId previous = null;
                        for (int j = 0; j < gidsCount; ++j) {
                            NodeId nodeId;
                            previous = nodeId = this.broker.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                            long address = StorageAddress.read(is);
                            StoredNode storedNode = this.broker.objectWith(new NodeProxy(this.doc, nodeId, address));
                            if (storedNode == null) {
                                throw new EXistException("Node " + nodeId + " in document " + document.getFileURI() + " not found.");
                            }
                            if (storedNode.getNodeType() != 1 && storedNode.getNodeType() != 2) {
                                LOG.error((Object)("Node " + nodeId + " in document " + document.getFileURI() + " is not an element or attribute node."));
                                LOG.error((Object)("Type = " + storedNode.getNodeType() + "; name = " + storedNode.getNodeName() + "; value = " + storedNode.getNodeValue()));
                                throw new EXistException("Node " + nodeId + " in document " + document.getURI() + " is not an element or attribute node.");
                            }
                            if (!storedNode.getLocalName().equals(nodeName)) {
                                LOG.error((Object)("Node name does not correspond to index entry. Expected " + nodeName + "; found " + storedNode.getLocalName()));
                            }
                            msg.append(StorageAddress.toString(address)).append(" ");
                        }
                    }
                }
                catch (EOFException e) {
                    LOG.warn((Object)("REPORT ME " + e.getMessage()), (Throwable)e);
                }
                LOG.debug((Object)msg.toString());
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.dbNodes.getFile().getName() + "'"), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    private Value computeKey(int collectionId, QName qname) {
        return this.computeTypedKey(qname.getNameType(), collectionId, qname);
    }

    private Value computeTypedKey(byte type, int collectionId, QName qname) {
        if (type == 2) {
            return new ElementValue(type, collectionId, qname.getLocalName());
        }
        if (type == 3) {
            return new ElementValue(type, collectionId, qname.getLocalName());
        }
        if (type == 4) {
            return new ElementValue(type, collectionId, qname.getLocalName());
        }
        SymbolTable symbols = this.broker.getBrokerPool().getSymbols();
        short sym = symbols.getSymbol(qname.getLocalName());
        short nsSym = symbols.getNSSymbol(qname.getNamespaceURI());
        return new ElementValue(type, collectionId, sym, nsSym);
    }

    private static boolean containsNode(List list, NodeId nodeId) {
        for (int i = 0; i < list.size(); ++i) {
            if (!((NodeProxy)list.get(i)).getNodeId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    public void closeAndRemove() {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        this.dbNodes.closeAndRemove();
    }

    public boolean close() throws DBException {
        this.config.setProperty(this.getConfigKeyForFile(), null);
        return this.dbNodes.close();
    }

    public void printStatistics() {
        this.dbNodes.printStatistics();
    }

    public String toString() {
        return this.getClass().getName() + " at " + this.dbNodes.getFile().getName() + " owned by " + this.broker.toString();
    }
}

