/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.btree.Value;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdateValueLoggable
extends BTAbstractLoggable {
    protected long pageNum;
    protected int idx;
    protected Value key;
    protected long pointer;
    protected long oldPointer;

    public UpdateValueLoggable(Txn transaction, byte fileId, long pageNum, int idx, Value key, long pointer, long oldPointer) {
        super((byte)36, fileId, transaction);
        this.pageNum = pageNum;
        this.idx = idx;
        this.key = key;
        this.pointer = pointer;
        this.oldPointer = oldPointer;
    }

    public UpdateValueLoggable(DBBroker broker, long transactionId) {
        super((byte)36, broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putShort((short)this.idx);
        out.putLong(this.pointer);
        out.putLong(this.oldPointer);
        out.putShort((short)this.key.getLength());
        out.put(this.key.data(), this.key.start(), this.key.getLength());
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.idx = in.getShort();
        this.pointer = in.getLong();
        this.oldPointer = in.getLong();
        byte[] data = new byte[in.getShort()];
        in.get(data);
        this.key = new Value(data);
    }

    public int getLogSize() {
        return super.getLogSize() + 24 + this.key.getLength();
    }

    public void redo() throws LogException {
        this.getStorage().redoUpdateValue(this);
    }

    public void undo() throws LogException {
        this.getStorage().undoUpdateValue(this);
    }

    public String dump() {
        return super.dump() + " - update btree key on page: " + this.pageNum;
    }
}

