/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class Value
implements Comparable {
    public static final Value EMPTY_VALUE = new Value(new byte[0]);
    private static Logger LOG = Logger.getLogger((String)Value.class.getName());
    protected long address = -1L;
    protected byte[] data = null;
    protected int pos = 0;
    protected int len = -1;

    public Value() {
    }

    public Value(Value value) {
        this.data = value.data;
        this.pos = value.pos;
        this.len = value.len;
    }

    public Value(byte[] data) {
        this.data = data;
        this.len = data.length;
    }

    public Value(byte[] data, int pos, int len) {
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public Value(String data) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            this.data = data.getBytes();
        }
        this.len = this.data.length;
    }

    public void setAddress(long addr) {
        this.address = addr;
    }

    public long getAddress() {
        return this.address;
    }

    public byte[] getData() {
        if (this.pos > 0 || this.len < this.data.length) {
            byte[] b = new byte[this.len];
            System.arraycopy(this.data, this.pos, b, 0, this.len);
            return b;
        }
        return this.data;
    }

    public final byte[] data() {
        return this.data;
    }

    public final int start() {
        return this.pos;
    }

    public final int getLength() {
        return this.len;
    }

    public String toString() {
        return this.dump();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Value value) {
        return this.len == value.len ? this.compareTo(value) == 0 : false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            return this.equals((Value)obj);
        }
        return this.equals(new Value(obj.toString()));
    }

    public final int compareTo(Value value) {
        int dlen = value.len;
        int stop = this.len > dlen ? dlen : this.len;
        for (int i = 0; i < stop; ++i) {
            byte b1 = this.data[this.pos + i];
            byte b2 = value.data[value.pos + i];
            if (b1 == b2) continue;
            short s1 = (short)(b1 & 0xFF);
            short s2 = (short)(b2 & 0xFF);
            return s1 > s2 ? i + 1 : -(i + 1);
        }
        if (this.len == dlen) {
            return 0;
        }
        return this.len > dlen ? stop + 1 : -(stop + 1);
    }

    public final int compareTo(Object obj) {
        if (obj instanceof Value) {
            return this.compareTo((Value)obj);
        }
        return this.compareTo(new Value(obj.toString()));
    }

    public final int comparePrefix(Value value) {
        int size = value.len;
        for (int i = 0; i < size; ++i) {
            byte b1 = this.data[this.pos + i];
            byte b2 = value.data[value.pos + i];
            if (b1 == b2) continue;
            short s1 = (short)(b1 & 0xFF);
            short s2 = (short)(b2 & 0xFF);
            return s1 > s2 ? i + 1 : -(i + 1);
        }
        return 0;
    }

    public final int comparePrefix(Value prefix, Value keyPrefix) {
        if (keyPrefix.getLength() >= prefix.getLength()) {
            int cmp = keyPrefix.comparePrefix(prefix);
            if (cmp != 0 || keyPrefix.getLength() == prefix.getLength()) {
                return cmp;
            }
            for (int i = prefix.getLength(); i < keyPrefix.getLength(); ++i) {
                byte b1 = this.data[this.pos + i];
                byte b2 = keyPrefix.data[keyPrefix.pos + i];
                if (b1 == b2) continue;
                short s1 = (short)(b1 & 0xFF);
                short s2 = (short)(b2 & 0xFF);
                return s1 > s2 ? i + 1 : -(i + 1);
            }
            return 0;
        }
        return prefix.comparePrefix(keyPrefix);
    }

    public final boolean startsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] vdata = value.data;
        int vpos = value.pos;
        for (int i = 0; i < value.len; ++i) {
            if (this.data[i + this.pos] == vdata[i + vpos]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] vdata = value.data;
        int vpos = value.pos;
        int d = this.len - value.len;
        for (int i = 0; i < value.len; ++i) {
            if (this.data[d + i + this.pos] == vdata[i + vpos]) continue;
            return false;
        }
        return true;
    }

    public int commonPrefix(Value other) {
        byte b;
        int i;
        int l = Math.min(this.len, other.len);
        for (i = 0; i < l && (b = this.data[this.pos + i]) == other.data[other.pos + i]; ++i) {
        }
        return i;
    }

    public int checkPrefix(Value prefix) {
        int l = Math.min(prefix.len, this.len);
        for (int i = 0; i < l; ++i) {
            if (prefix.data[prefix.pos + i] == this.data[this.pos + i]) continue;
            return i;
        }
        return l;
    }

    public Value getSeparator(Value other) {
        int offset = this.commonPrefix(other) + 1;
        byte[] data = new byte[Math.abs(offset)];
        System.arraycopy(other.getData(), 0, data, 0, data.length);
        return new Value(data);
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.len; ++i) {
            buf.append(Integer.toString(this.data[this.pos + i] & 0xFF));
            buf.append(' ');
        }
        return buf.toString();
    }
}

