/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.CacheManager;
import org.exist.storage.cache.Accounting;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.Long2ObjectHashMap;

public class GClockCache
implements Cache {
    protected Cacheable[] items;
    protected int count = 0;
    protected int size;
    protected Long2ObjectHashMap map;
    protected int used = 0;
    protected int hitsOld = 0;
    protected Accounting accounting;
    protected double growthFactor;
    protected CacheManager cacheManager = null;
    private String fileName = "unknown";
    private String type;

    public GClockCache(int size, double growthFactor, double growthThreshold, String type) {
        this.size = size;
        this.growthFactor = growthFactor;
        this.items = new Cacheable[size];
        this.map = new Long2ObjectHashMap(size * 2);
        this.accounting = new Accounting(growthThreshold);
        this.accounting.setTotalSize(size);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void add(Cacheable item) {
        this.add(item, 1);
    }

    public void add(Cacheable item, int initialRefCount) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.incReferenceCount();
            return;
        }
        item.setReferenceCount(initialRefCount);
        if (this.count < this.size) {
            this.items[this.count++] = item;
            this.map.put(item.getKey(), item);
            ++this.used;
        } else {
            this.removeOne(item);
        }
    }

    public Cacheable get(Cacheable item) {
        return this.get(item.getKey());
    }

    public Cacheable get(long key) {
        Cacheable item = (Cacheable)this.map.get(key);
        if (item == null) {
            this.accounting.missesIncrement();
        } else {
            this.accounting.hitIncrement();
        }
        return item;
    }

    public void remove(Cacheable item) {
        long key = item.getKey();
        Cacheable cacheable = (Cacheable)this.map.remove(key);
        if (cacheable == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || this.items[i].getKey() != key) continue;
            this.items[i] = null;
            --this.used;
            return;
        }
        LOG.error((Object)"item not found in list");
    }

    public boolean flush() {
        boolean flushed = false;
        int written = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].sync(false)) continue;
            ++written;
            flushed = true;
        }
        return flushed;
    }

    public boolean hasDirtyItems() {
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    protected Cacheable removeOne(Cacheable item) {
        Cacheable old = null;
        boolean removed = false;
        do {
            int bucket = -1;
            for (int i = 0; i < this.count; ++i) {
                old = this.items[i];
                if (old == null) {
                    bucket = i;
                    continue;
                }
                if (old.decReferenceCount() >= 1 || bucket >= 0) continue;
                bucket = i;
            }
            if (bucket <= -1) continue;
            old = this.items[bucket];
            if (old != null) {
                this.map.remove(old.getKey());
                old.sync(true);
            } else {
                ++this.used;
            }
            this.items[bucket] = item;
            this.map.put(item.getKey(), item);
            removed = true;
        } while (!removed);
        if (old != null) {
            this.accounting.replacedPage(item);
            if (this.cacheManager != null && this.accounting.resizeNeeded()) {
                this.cacheManager.requestMem(this);
            }
        }
        return old;
    }

    public int getBuffers() {
        return this.size;
    }

    public int getUsedBuffers() {
        return this.used;
    }

    public double getGrowthFactor() {
        return this.growthFactor;
    }

    public int getHits() {
        return this.accounting.getHits();
    }

    public int getFails() {
        return this.accounting.getMisses();
    }

    public int getThrashing() {
        return this.accounting.getThrashing();
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public void resize(int newSize) {
        if (newSize < this.size) {
            this.shrink(newSize);
        } else {
            Cacheable[] newItems = new Cacheable[newSize];
            Long2ObjectHashMap newMap = new Long2ObjectHashMap(newSize * 2);
            for (int i = 0; i < this.count; ++i) {
                newItems[i] = this.items[i];
                newMap.put(this.items[i].getKey(), this.items[i]);
            }
            this.size = newSize;
            this.map = newMap;
            this.items = newItems;
            this.accounting.reset();
            this.accounting.setTotalSize(this.size);
        }
    }

    protected void shrink(int newSize) {
        this.flush();
        this.items = new Cacheable[newSize];
        this.map = new Long2ObjectHashMap(newSize * 2);
        this.size = newSize;
        this.count = 0;
        this.used = 0;
        this.accounting.reset();
        this.accounting.setTotalSize(this.size);
    }

    public int getLoad() {
        if (this.hitsOld == 0) {
            this.hitsOld = this.accounting.getHits();
            return Integer.MAX_VALUE;
        }
        int load = this.accounting.getHits() - this.hitsOld;
        this.hitsOld = this.accounting.getHits();
        return load;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }
}

