/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.CacheManager;
import org.exist.storage.cache.Accounting;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.SequencedLongHashMap;

public class LRUCache
implements Cache {
    private int max;
    private SequencedLongHashMap map;
    private Accounting accounting;
    private int hitsOld = -1;
    private double growthFactor;
    private String fileName;
    private CacheManager cacheManager = null;
    private String type;

    public LRUCache(int size, double growthFactor, double growthThreshold, String type) {
        this.max = size;
        this.growthFactor = growthFactor;
        this.map = new SequencedLongHashMap(size * 2);
        this.accounting = new Accounting(growthThreshold);
        this.accounting.setTotalSize(this.max);
        this.type = type;
    }

    public void add(Cacheable item, int initialRefCount) {
        this.add(item);
    }

    public String getType() {
        return this.type;
    }

    public void add(Cacheable item) {
        if (this.map.size() == this.max) {
            this.removeOne(item);
        }
        this.map.put(item.getKey(), item);
    }

    public Cacheable get(Cacheable item) {
        return this.get(item.getKey());
    }

    public Cacheable get(long key) {
        Cacheable obj = (Cacheable)this.map.get(key);
        if (obj == null) {
            this.accounting.missesIncrement();
        } else {
            this.accounting.hitIncrement();
        }
        return obj;
    }

    public void remove(Cacheable item) {
        this.map.remove(item.getKey());
    }

    public boolean flush() {
        boolean flushed = false;
        for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            flushed |= cacheable.sync(false);
        }
        return flushed;
    }

    public boolean hasDirtyItems() {
        for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            return true;
        }
        return false;
    }

    public int getBuffers() {
        return this.max;
    }

    public int getUsedBuffers() {
        return this.map.size();
    }

    public int getHits() {
        return this.accounting.getHits();
    }

    public int getFails() {
        return this.accounting.getMisses();
    }

    public int getThrashing() {
        return this.accounting.getThrashing();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SequencedLongHashMap.Entry getFirst() {
        return this.map.getFirstEntry();
    }

    private final void removeOne(Cacheable item) {
        boolean removed = false;
        SequencedLongHashMap.Entry next = this.map.getFirstEntry();
        do {
            Cacheable cached;
            if ((cached = (Cacheable)next.getValue()).allowUnload() && cached.getKey() != item.getKey()) {
                cached.sync(true);
                this.map.remove(next.getKey());
                removed = true;
                continue;
            }
            if ((next = next.getNext()) != null) continue;
            LOG.debug((Object)"Unable to remove entry");
            next = this.map.getFirstEntry();
        } while (!removed);
        this.accounting.replacedPage(item);
        if (this.growthFactor > 1.0 && this.accounting.resizeNeeded()) {
            this.cacheManager.requestMem(this);
        }
    }

    public double getGrowthFactor() {
        return this.growthFactor;
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public void resize(int newSize) {
        if (newSize < this.max) {
            this.shrink(newSize);
        } else {
            SequencedLongHashMap newMap = new SequencedLongHashMap(newSize * 2);
            for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
                Cacheable cacheable = (Cacheable)next.getValue();
                newMap.put(cacheable.getKey(), cacheable);
            }
            this.max = newSize;
            this.map = newMap;
            this.accounting.reset();
            this.accounting.setTotalSize(this.max);
        }
    }

    private void shrink(int newSize) {
        this.flush();
        this.map = new SequencedLongHashMap(newSize);
        this.max = newSize;
        this.accounting.reset();
        this.accounting.setTotalSize(this.max);
    }

    public int getLoad() {
        if (this.hitsOld == 0) {
            this.hitsOld = this.accounting.getHits();
            return Integer.MAX_VALUE;
        }
        int load = this.accounting.getHits() - this.hitsOld;
        this.hitsOld = this.accounting.getHits();
        return load;
    }
}

