/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.ItemId;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveValueLoggable
extends AbstractLoggable {
    private DOMFile domDb;
    protected long pageNum;
    protected short tid;
    protected int offset;
    protected byte[] oldData;
    protected boolean isOverflow;
    protected long backLink;

    public RemoveValueLoggable(Txn transaction, long pageNum, short tid, int offset, byte[] oldData, boolean isOverflow, long backLink) {
        super((byte)18, transaction.getId());
        this.pageNum = pageNum;
        this.tid = tid;
        this.offset = offset;
        this.oldData = oldData;
        this.isOverflow = isOverflow;
        this.backLink = backLink;
    }

    public RemoveValueLoggable(DBBroker broker, long transactionId) {
        super((byte)18, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.put((byte)(this.isOverflow ? 1 : 0));
        out.putInt((int)this.pageNum);
        out.putShort(this.tid);
        out.putShort((short)this.offset);
        out.putShort((short)this.oldData.length);
        out.put(this.oldData);
        if (ItemId.isRelocated(this.tid)) {
            out.putLong(this.backLink);
        }
    }

    public void read(ByteBuffer in) {
        this.isOverflow = in.get() == 1;
        this.pageNum = in.getInt();
        this.tid = in.getShort();
        this.offset = in.getShort();
        this.oldData = new byte[in.getShort()];
        in.get(this.oldData);
        if (ItemId.isRelocated(this.tid)) {
            this.backLink = in.getLong();
        }
    }

    public int getLogSize() {
        return 11 + this.oldData.length + (ItemId.isRelocated(this.tid) ? 8 : 0);
    }

    public void redo() throws LogException {
        this.domDb.redoRemoveValue(this);
    }

    public void undo() throws LogException {
        this.domDb.undoRemoveValue(this);
    }

    public String dump() {
        return super.dump() + " - removed value; tid = " + ItemId.getId(this.tid) + " from page " + this.pageNum + " at " + this.offset + "; len = " + this.oldData.length;
    }
}

