/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.Value;
import org.exist.storage.index.BFile;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.UTF8;

public class CollectionStore
extends BFile {
    public static final String FILE_NAME = "collections.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.collections";
    public static final String FREE_DOC_ID_KEY = "__free_doc_id";
    public static final String NEXT_DOC_ID_KEY = "__next_doc_id";
    public static final String FREE_COLLECTION_ID_KEY = "__free_collection_id";
    public static final String NEXT_COLLECTION_ID_KEY = "__next_collection_id";
    public static final byte KEY_TYPE_COLLECTION = 0;
    public static final byte KEY_TYPE_DOCUMENT = 1;

    public CollectionStore(BrokerPool pool, byte id, String dataDir, Configuration config) throws DBException {
        super(pool, id, true, new File(dataDir + File.separatorChar + CollectionStore.getFileName()), pool.getCacheManager(), 1.25, 0.01, 0.03);
        config.setProperty(CollectionStore.getConfigKeyForFile(), this);
    }

    public static String getFileName() {
        return FILE_NAME;
    }

    public static String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    protected long getBTreeSyncPeriod() {
        return 1000L;
    }

    protected long getDataSyncPeriod() {
        return 1000L;
    }

    public boolean flush() throws DBException {
        boolean flushed = false;
        if (!BrokerPool.FORCE_CORRUPTION) {
            flushed |= this.dataCache.flush();
            flushed |= super.flush();
        }
        return flushed;
    }

    protected void dumpValue(Writer writer, Value value) throws IOException {
        if (value.getLength() == 5 + Collection.LENGTH_COLLECTION_ID) {
            short collectionId = ByteConversion.byteToShort(value.data(), value.start());
            int docId = ByteConversion.byteToInt(value.data(), value.start() + 1 + Collection.LENGTH_COLLECTION_ID);
            writer.write(91);
            writer.write("Document: collection = ");
            writer.write(collectionId);
            writer.write(", docId = ");
            writer.write(docId);
            writer.write(93);
        } else {
            writer.write(91);
            writer.write("Collection: ");
            writer.write(new String(value.data(), value.start(), value.getLength(), "UTF-8"));
            writer.write(93);
        }
    }

    public static class CollectionKey
    extends Value {
        public static int OFFSET_TYPE = 0;
        public static int LENGTH_TYPE = 1;
        public static int OFFSET_VALUE = OFFSET_TYPE + LENGTH_TYPE;

        public CollectionKey() {
            this.data = new byte[LENGTH_TYPE];
            this.data[CollectionKey.OFFSET_TYPE] = 0;
            this.len = LENGTH_TYPE;
        }

        public CollectionKey(String name) {
            this.len = LENGTH_TYPE + UTF8.encoded(name);
            this.data = new byte[this.len];
            this.data[CollectionKey.OFFSET_TYPE] = 0;
            UTF8.encode(name, this.data, OFFSET_VALUE);
            this.pos = OFFSET_TYPE;
        }
    }

    public static class DocumentKey
    extends Value {
        public static int OFFSET_TYPE = 0;
        public static int LENGTH_TYPE = 1;
        public static int OFFSET_COLLECTION_ID = OFFSET_TYPE + LENGTH_TYPE;
        public static int LENGTH_TYPE_DOCUMENT = 2;
        public static int OFFSET_DOCUMENT_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
        public static int LENGTH_DOCUMENT_TYPE = 1;
        public static int OFFSET_DOCUMENT_ID = OFFSET_DOCUMENT_TYPE + LENGTH_DOCUMENT_TYPE;

        public DocumentKey() {
            this.data = new byte[LENGTH_TYPE];
            this.data[DocumentKey.OFFSET_TYPE] = 1;
            this.len = LENGTH_TYPE;
        }

        public DocumentKey(int collectionId) {
            this.data = new byte[LENGTH_TYPE + Collection.LENGTH_COLLECTION_ID];
            this.data[DocumentKey.OFFSET_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.len = LENGTH_TYPE + Collection.LENGTH_COLLECTION_ID;
            this.pos = OFFSET_TYPE;
        }

        public DocumentKey(int collectionId, byte type, int docId) {
            this.data = new byte[LENGTH_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_DOCUMENT_TYPE + DocumentImpl.LENGTH_DOCUMENT_ID];
            this.data[DocumentKey.OFFSET_TYPE] = 1;
            ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
            this.data[DocumentKey.OFFSET_DOCUMENT_TYPE] = type;
            ByteConversion.intToByte(docId, this.data, OFFSET_DOCUMENT_ID);
            this.len = LENGTH_TYPE + Collection.LENGTH_COLLECTION_ID + LENGTH_DOCUMENT_TYPE + DocumentImpl.LENGTH_DOCUMENT_ID;
            this.pos = OFFSET_TYPE;
        }

        public static int getCollectionId(Value key) {
            return ByteConversion.byteToInt(key.data(), key.start() + OFFSET_COLLECTION_ID);
        }

        public static int getDocumentId(Value key) {
            return ByteConversion.byteToInt(key.data(), key.start() + OFFSET_DOCUMENT_ID);
        }
    }
}

