/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowRemoveLoggable
extends AbstractBFileLoggable {
    protected byte status;
    protected long pageNum;
    protected byte[] data;
    protected int length;
    protected long nextInChain;

    public OverflowRemoveLoggable(byte fileId, Txn transaction, byte status, long pageNum, byte[] data, int length, long nextInChain) {
        super((byte)57, fileId, transaction);
        this.status = status;
        this.pageNum = pageNum;
        this.data = data;
        this.length = length;
        this.nextInChain = nextInChain;
    }

    public OverflowRemoveLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.put(this.status);
        out.putInt((int)this.pageNum);
        out.putInt((int)this.nextInChain);
        out.putInt(this.length);
        out.put(this.data, 0, this.length);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.status = in.get();
        this.pageNum = in.getInt();
        this.nextInChain = in.getInt();
        this.length = in.getInt();
        this.data = new byte[this.length];
        in.get(this.data);
    }

    public int getLogSize() {
        return super.getLogSize() + 13 + this.length;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoRemoveOverflow(this);
    }

    public void undo() throws LogException {
        this.getIndexFile().undoRemoveOverflow(this);
    }

    public String dump() {
        return super.dump() + " - remove overflow page " + this.pageNum;
    }
}

