/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.txn;

import java.util.ArrayList;
import java.util.List;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;

public class Txn {
    private long id;
    private List locksHeld = new ArrayList();

    public Txn(long transactionId) {
        this.id = transactionId;
    }

    public long getId() {
        return this.id;
    }

    public void registerLock(Lock lock, int lockMode) {
        this.locksHeld.add(new LockInfo(lock, lockMode));
    }

    public void acquireLock(Lock lock, int lockMode) throws LockException {
        lock.acquire(lockMode);
        this.locksHeld.add(new LockInfo(lock, lockMode));
    }

    public void releaseAll() {
        for (int i = this.locksHeld.size() - 1; i >= 0; --i) {
            LockInfo info = (LockInfo)this.locksHeld.get(i);
            info.lock.release(info.lockMode);
        }
        this.locksHeld.clear();
    }

    private class LockInfo {
        Lock lock;
        int lockMode;

        public LockInfo(Lock lock, int lockMode) {
            this.lock = lock;
            this.lockMode = lockMode;
        }
    }
}

