/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.Writer;
import org.exist.util.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private long value;

    public CompressedWhitespace(long compressedValue) {
        this.value = compressedValue;
    }

    public static CharSequence compress(CharSequence in) {
        int i;
        int inlen = in.length();
        if (inlen == 0) {
            return in;
        }
        int runlength = 1;
        int outlength = 0;
        for (int i2 = 0; i2 < inlen; ++i2) {
            char c = in.charAt(i2);
            if ("\t\n\r ".indexOf(c) >= 0) {
                if (i2 == inlen - 1 || c != in.charAt(i2 + 1) || runlength == 63) {
                    runlength = 1;
                    if (++outlength <= 8) continue;
                    return in;
                }
                ++runlength;
                continue;
            }
            return in;
        }
        int ix = 0;
        runlength = 1;
        int[] out = new int[outlength];
        for (int i3 = 0; i3 < inlen; ++i3) {
            char c = in.charAt(i3);
            if (i3 == inlen - 1 || c != in.charAt(i3 + 1) || runlength == 63) {
                int code = "\t\n\r ".indexOf(c);
                out[ix++] = code << 6 | runlength;
                runlength = 1;
                continue;
            }
            ++runlength;
        }
        long value = 0L;
        for (i = 0; i < outlength; ++i) {
            value = value << 8 | (long)out[i];
        }
        for (i = 0; i < 8 - outlength; ++i) {
            value <<= 8;
        }
        return new CompressedWhitespace(value);
    }

    public FastStringBuffer uncompress(FastStringBuffer buffer) {
        byte b;
        if (buffer == null) {
            buffer = new FastStringBuffer(this.length());
        }
        long val = this.value;
        for (int s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            for (int j = 0; j < len; ++j) {
                buffer.append(c);
            }
        }
        return buffer;
    }

    public long getCompressedValue() {
        return this.value;
    }

    public int length() {
        int c;
        int count = 0;
        long val = this.value;
        for (int s = 56; s >= 0 && (c = (int)(val >>> s & 0x3FL)) != 0; s -= 8) {
            count += c;
        }
        return count;
    }

    public char charAt(int index) {
        byte b;
        int count = 0;
        long val = this.value;
        for (int s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            if ((count += b & 0x3F) <= index) continue;
            return WHITE_CHARS[b >>> 6 & 3];
        }
        throw new IndexOutOfBoundsException(index + "");
    }

    public CharSequence subSequence(int start, int end) {
        return this.uncompress(null).subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)obj).value;
        }
        return this.uncompress(null).equals(obj);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) throws IOException {
        byte b;
        long val = this.value;
        for (int s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            for (int j = 0; j < len; ++j) {
                writer.write(c);
            }
        }
    }

    public void writeEscape(boolean[] specialChars, Writer writer) throws IOException {
        byte b;
        long val = this.value;
        for (int s = 56; s >= 0 && (b = (byte)(val >>> s & 0xFFL)) != 0; s -= 8) {
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            if (specialChars[c]) {
                String e = "";
                if (c == '\n') {
                    e = "&#xA;";
                } else if (c == '\r') {
                    e = "&#xD;";
                } else if (c == '\t') {
                    e = "&#x9;";
                }
                for (int j = 0; j < len; ++j) {
                    writer.write(e);
                }
                continue;
            }
            for (int j = 0; j < len; ++j) {
                writer.write(c);
            }
        }
    }

    public static void main(String[] args) {
        CharSequence c = CompressedWhitespace.compress("\t\n\n\t\t\n      ");
        System.err.println(c);
    }
}

