/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.exist.util.CharSlice;
import org.exist.util.CompressedWhitespace;
import org.exist.util.XMLChar;

public final class FastStringBuffer
implements CharSequence,
Serializable {
    private char[] array;
    private int used = 0;
    public static final int SUPPRESS_LEADING_WS = 1;
    public static final int SUPPRESS_TRAILING_WS = 2;
    public static final int SUPPRESS_BOTH = 3;

    public FastStringBuffer(int initialSize) {
        this.array = new char[initialSize];
    }

    public void append(String s) {
        int len = s.length();
        this.ensureCapacity(len);
        s.getChars(0, len, this.array, this.used);
        this.used += len;
    }

    public void append(CharSlice s) {
        int len = s.length();
        this.ensureCapacity(len);
        s.copyTo(this.array, this.used);
        this.used += len;
    }

    public void append(FastStringBuffer s) {
        int len = s.length();
        this.ensureCapacity(len);
        s.getChars(0, len, this.array, this.used);
        this.used += len;
    }

    public void append(StringBuffer s) {
        int len = s.length();
        this.ensureCapacity(len);
        s.getChars(0, len, this.array, this.used);
        this.used += len;
    }

    public void append(CharSequence s) {
        int len = s.length();
        this.ensureCapacity(len);
        if (s instanceof CharSlice) {
            ((CharSlice)s).copyTo(this.array, this.used);
        } else if (s instanceof String) {
            ((String)s).getChars(0, len, this.array, this.used);
        } else if (s instanceof FastStringBuffer) {
            ((FastStringBuffer)s).getChars(0, len, this.array, this.used);
        } else {
            if (s instanceof CompressedWhitespace) {
                ((CompressedWhitespace)s).uncompress(this);
                return;
            }
            ((Object)s).toString().getChars(0, len, this.array, this.used);
        }
        this.used += len;
    }

    public void append(char[] srcArray, int start, int length) {
        this.ensureCapacity(length);
        System.arraycopy(srcArray, start, this.array, this.used, length);
        this.used += length;
    }

    public void append(char[] srcArray) {
        int length = srcArray.length;
        this.ensureCapacity(length);
        System.arraycopy(srcArray, 0, this.array, this.used, length);
        this.used += length;
    }

    public void append(char ch) {
        this.ensureCapacity(1);
        this.array[this.used++] = ch;
    }

    public void appendWideChar(int ch) {
        if (ch > 65535) {
            this.append(XMLChar.highSurrogate(ch));
            this.append(XMLChar.lowSurrogate(ch));
        } else {
            this.append((char)ch);
        }
    }

    public void prependWideChar(int ch) {
        if (ch > 65535) {
            this.insertCharAt(0, XMLChar.lowSurrogate(ch));
            this.insertCharAt(0, XMLChar.highSurrogate(ch));
        } else {
            this.insertCharAt(0, (char)ch);
        }
    }

    public int length() {
        return this.used;
    }

    public char charAt(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.array[index];
    }

    public CharSequence subSequence(int start, int end) {
        return new CharSlice(this.array, start, end - start);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.used) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.array, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public int indexOf(char ch) {
        for (int i = 0; i < this.used; ++i) {
            if (this.array[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        this.condense();
        return new String(this.array, 0, this.used);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index > this.used) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.array[index] = ch;
    }

    public void insertCharAt(int index, char ch) {
        if (index < 0 || index > this.used) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.ensureCapacity(1);
        for (int i = this.used; i > index; --i) {
            this.array[i] = this.array[i - 1];
        }
        ++this.used;
        this.array[index] = ch;
    }

    public void removeCharAt(int index) {
        if (index < 0 || index > this.used) {
            throw new IndexOutOfBoundsException("" + index);
        }
        --this.used;
        for (int i = index; i < this.used; ++i) {
            this.array[i] = this.array[i + 1];
        }
    }

    public void setLength(int length) {
        if (length < 0 || length > this.used) {
            return;
        }
        this.used = length;
    }

    public void ensureCapacity(int extra) {
        if (this.used + extra > this.array.length) {
            int newlen = this.array.length * 2;
            if (newlen < this.used + extra) {
                newlen = this.used + extra * 2;
            }
            char[] array2 = new char[newlen];
            System.arraycopy(this.array, 0, array2, 0, this.used);
            this.array = array2;
        }
    }

    public CharSequence condense() {
        if (this.array.length - this.used > 256 || this.array.length > this.used * 2) {
            char[] array2 = new char[this.used];
            System.arraycopy(this.array, 0, array2, 0, this.used);
            this.array = array2;
        }
        return this;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.array, 0, this.used);
    }

    public static String diagnosticPrint(CharSequence in) {
        FastStringBuffer buff = new FastStringBuffer(in.length() * 2);
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c > ' ' && c < '\u007f') {
                buff.append(c);
                continue;
            }
            buff.append("\\u");
            for (int d = 12; d >= 0; d -= 4) {
                buff.append("0123456789abcdef".charAt(c >> d & 0xF));
            }
        }
        return buff.toString();
    }

    public String getNormalizedString(int mode) {
        return this.getNormalizedString(new StringBuffer(this.toString()), mode).toString();
    }

    public StringBuffer getNormalizedString(StringBuffer sb, int mode) {
        return new StringBuffer(this.toString().trim());
    }
}

