/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderObjectFactory
extends BasePoolableObjectFactory {
    public static final int VALIDATION_UNKNOWN = -1;
    public static final int VALIDATION_ENABLED = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DISABLED = 2;
    public static final String CONFIGURATION_ENTITY_RESOLVER_ELEMENT_NAME = "entity-resolver";
    public static final String CONFIGURATION_CATALOG_ELEMENT_NAME = "catalog";
    public static final String CONFIGURATION_ELEMENT_NAME = "validation";
    public static final String VALIDATION_MODE_ATTRIBUTE = "mode";
    public static final String PROPERTY_VALIDATION_MODE = "validation.mode";
    public static final String CATALOG_RESOLVER = "validation.resolver";
    public static final String CATALOG_URIS = "validation.catalog_uris";
    public static final String GRAMMER_POOL = "validation.grammar_pool";
    public static final String FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String PROPERTIES_INTERNAL_GRAMMARPOOL = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String PROPERTIES_LOAD_EXT_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String PROPERTIES_ENTITYRESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private BrokerPool pool;

    public XMLReaderObjectFactory(BrokerPool pool) {
        this.pool = pool;
    }

    public Object makeObject() throws Exception {
        Configuration config = this.pool.getConfiguration();
        String option = (String)config.getProperty(PROPERTY_VALIDATION_MODE);
        int validation = XMLReaderObjectFactory.convertValidationMode(option);
        GrammarPool grammarPool = (GrammarPool)config.getProperty(GRAMMER_POOL);
        eXistXMLCatalogResolver resolver = (eXistXMLCatalogResolver)((Object)config.getProperty(CATALOG_RESOLVER));
        XMLReader xmlReader = XMLReaderObjectFactory.createXmlReader(validation, grammarPool, resolver);
        XMLReaderObjectFactory.setReaderValidationMode(validation, xmlReader);
        return xmlReader;
    }

    public static XMLReader createXmlReader(int validation, GrammarPool grammarPool, eXistXMLCatalogResolver resolver) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        if (validation == 1 || validation == 0) {
            saxFactory.setValidating(true);
        } else {
            saxFactory.setValidating(false);
        }
        saxFactory.setNamespaceAware(true);
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        if (grammarPool != null) {
            xmlReader.setProperty(PROPERTIES_INTERNAL_GRAMMARPOOL, grammarPool);
        }
        if (resolver != null) {
            xmlReader.setProperty(PROPERTIES_ENTITYRESOLVER, (Object)resolver);
        }
        return xmlReader;
    }

    public static int convertValidationMode(String option) {
        int validation = 1;
        if (option != null) {
            validation = option.equals("true") || option.equals("yes") ? 0 : (option.equals("auto") ? 1 : 2);
        }
        return validation;
    }

    public static void setReaderValidationMode(int validation, XMLReader xmlReader) {
        if (validation == -1) {
            return;
        }
        try {
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlReader.setFeature("http://xml.org/sax/features/validation", validation == 1 || validation == 0);
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", validation == 1);
            xmlReader.setFeature(FEATURES_VALIDATION_SCHEMA, validation == 1 || validation == 0);
            xmlReader.setFeature(PROPERTIES_LOAD_EXT_DTD, validation == 1 || validation == 0);
        }
        catch (SAXNotRecognizedException e1) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }
}

