/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import org.exist.util.hashtable.AbstractHashtable;
import org.exist.util.hashtable.Object2LongHashMap;

public class Object2LongIdentityHashMap
extends Object2LongHashMap {
    public Object2LongIdentityHashMap() {
    }

    public Object2LongIdentityHashMap(int iSize) {
        super(iSize);
    }

    public long get(Object key) {
        int idx = Object2LongIdentityHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx] == key) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (this.keys[idx] != key) continue;
            return this.values[idx];
        }
        return -1L;
    }

    public boolean containsKey(Object key) {
        int idx = Object2LongIdentityHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx] == key) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (this.keys[idx] != key) continue;
            return true;
        }
        return false;
    }

    public long remove(Object key) {
        int idx = Object2LongIdentityHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx] == key) {
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (this.keys[idx] != key) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        return -1L;
    }

    protected void insert(Object key, long value) throws AbstractHashtable.HashtableOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2LongIdentityHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx] == key) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }
}

