/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.pool;

import java.util.LinkedList;
import org.exist.dom.AttrImpl;
import org.exist.dom.CDATASectionImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.TextImpl;
import org.exist.util.hashtable.Int2ObjectHashMap;

public class NodePool {
    public static final int MAX_OBJECTS = 20;
    private static ThreadLocal pools = new PoolThreadLocal();
    private int maxActive;
    private Int2ObjectHashMap poolMap = new Int2ObjectHashMap(17);

    public static NodePool getInstance() {
        return (NodePool)pools.get();
    }

    public NodePool(int maxObjects) {
        this.maxActive = maxObjects;
    }

    public NodeImpl borrowNode(short key) {
        Pool pool = (Pool)this.poolMap.get(key);
        if (pool == null) {
            pool = new Pool();
            this.poolMap.put(key, pool);
        }
        return pool.borrowNode(key);
    }

    public void returnNode(NodeImpl node) {
        Pool pool = (Pool)this.poolMap.get(node.getNodeType());
        if (pool != null) {
            pool.returnNode(node);
        }
    }

    public int getSize(short key) {
        Pool pool = (Pool)this.poolMap.get(key);
        return pool.stack.size();
    }

    private NodeImpl makeObject(short key) {
        switch (key) {
            case 1: {
                return new ElementImpl();
            }
            case 3: {
                return new TextImpl();
            }
            case 2: {
                return new AttrImpl();
            }
            case 4: {
                return new CDATASectionImpl();
            }
            case 7: {
                return new ProcessingInstructionImpl();
            }
            case 8: {
                return new CommentImpl();
            }
        }
        throw new IllegalStateException("Unable to create object of type " + key);
    }

    private class Pool {
        private LinkedList stack = new LinkedList();

        private Pool() {
        }

        public NodeImpl borrowNode(short key) {
            if (this.stack.isEmpty()) {
                return NodePool.this.makeObject(key);
            }
            return (NodeImpl)this.stack.removeLast();
        }

        public void returnNode(NodeImpl node) {
            if (this.stack.size() < NodePool.this.maxActive) {
                this.stack.addLast(node);
            }
        }
    }

    private static class PoolThreadLocal
    extends ThreadLocal {
        private PoolThreadLocal() {
        }

        protected Object initialValue() {
            return new NodePool(20);
        }
    }
}

