/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.validation.ValidationReportItem;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationReport
implements ErrorHandler {
    private ArrayList validationReport = new ArrayList();
    private ValidationReportItem lastItem;
    private long duration = -1L;
    private long start = -1L;
    private long stop = -1L;
    private Throwable throwed = null;
    private String namespaceUri = null;

    private ValidationReportItem createValidationReportItem(int type, SAXParseException exception) {
        ValidationReportItem vri = new ValidationReportItem();
        vri.setType(type);
        vri.setLineNumber(exception.getLineNumber());
        vri.setColumnNumber(exception.getColumnNumber());
        vri.setMessage(exception.getMessage());
        vri.setPublicId(exception.getPublicId());
        vri.setSystemId(exception.getSystemId());
        return vri;
    }

    private void addItem(ValidationReportItem newItem) {
        if (this.lastItem == null) {
            this.validationReport.add(newItem);
            this.lastItem = newItem;
        } else if (this.lastItem.getMessage().equals(newItem.getMessage())) {
            this.lastItem.increaseRepeat();
        } else {
            this.validationReport.add(newItem);
            this.lastItem = newItem;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(2, exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(4, exception));
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.addItem(this.createValidationReportItem(1, exception));
    }

    public void setException(Exception ex) {
        this.throwed = ex;
    }

    public boolean isValid() {
        return this.validationReport.size() == 0 && this.throwed == null;
    }

    public List getValidationReportItemList() {
        return this.validationReport;
    }

    public List getTextValidationReport() {
        ArrayList<String> textReport = new ArrayList<String>();
        if (this.isValid()) {
            textReport.add("Document is valid.");
        } else {
            textReport.add("Document is not valid.");
        }
        if (this.throwed != null) {
            textReport.add("Exception: " + this.throwed.getMessage());
        }
        Iterator iter = this.validationReport.iterator();
        while (iter.hasNext()) {
            textReport.add(iter.next().toString());
        }
        textReport.add("Validated in " + this.duration + " millisec.");
        return textReport;
    }

    public String[] getValidationReportArray() {
        List validationReport = this.getTextValidationReport();
        String[] report = new String[validationReport.size()];
        int counter = 0;
        Iterator iter = validationReport.iterator();
        while (iter.hasNext()) {
            report[counter] = iter.next().toString();
            ++counter;
        }
        return report;
    }

    public void setValidationDuration(long time) {
        this.duration = time;
    }

    public long getValidationDuration() {
        return this.duration;
    }

    public String toString() {
        StringBuffer validationReport = new StringBuffer();
        Iterator reportIterator = this.getTextValidationReport().iterator();
        while (reportIterator.hasNext()) {
            validationReport.append(reportIterator.next().toString());
            validationReport.append("\n");
        }
        return validationReport.toString();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        if (this.getValidationDuration() == -1L) {
            this.stop = System.currentTimeMillis();
            this.setValidationDuration(this.stop - this.start);
        }
    }

    public void setThrowable(Throwable throwable) {
        this.throwed = throwable;
    }

    public Throwable getThrowable() {
        return this.throwed;
    }

    public void setNamespaceUri(String namespace) {
        this.namespaceUri = namespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }
}

