/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.source.ClassLoaderSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DatabaseResources {
    public static final String QUERY_LOCATION = "org/exist/validation/internal/query/";
    public static final String FIND_XSD = "org/exist/validation/internal/query/find_schema_by_targetNamespace.xq";
    public static final String FIND_CATALOGS_WITH_DTD = "org/exist/validation/internal/query/find_catalogs_with_dtd.xq";
    public static final String PUBLICID = "publicId";
    public static final String TARGETNAMESPACE = "targetNamespace";
    public static final String CATALOG = "catalog";
    public static final String COLLECTION = "collection";
    private BrokerPool brokerPool = null;
    private static final Logger logger = Logger.getLogger((Class)DatabaseResources.class);

    public List getAllResults(Sequence sequence) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            SequenceIterator i = sequence.iterate();
            while (i.hasNext()) {
                String path = i.nextItem().getStringValue();
                result.add(path);
            }
        }
        catch (XPathException ex) {
            logger.error((Object)"xQuery issue.", (Throwable)ex);
            result = null;
        }
        return result;
    }

    public String getFirstResult(Sequence sequence) {
        String result = null;
        try {
            SequenceIterator i = sequence.iterate();
            if (i.hasNext()) {
                result = i.nextItem().getStringValue();
                logger.debug((Object)("Single query result: '" + result + "'."));
            } else {
                logger.debug((Object)"No query result.");
            }
        }
        catch (XPathException ex) {
            logger.error((Object)"xQuery issue ", (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence executeQuery(String queryPath, Map params, User user) {
        String namespace = (String)params.get(TARGETNAMESPACE);
        String publicId = (String)params.get(PUBLICID);
        String catalogPath = (String)params.get(CATALOG);
        String collection = (String)params.get(COLLECTION);
        logger.debug((Object)("collection=" + collection + " namespace=" + namespace + " publicId=" + publicId + " catalogPath=" + catalogPath));
        DBBroker broker = null;
        Sequence result = null;
        try {
            broker = this.brokerPool.get(user);
            CompiledXQuery compiled = null;
            XQuery xquery = broker.getXQueryService();
            XQueryContext context = xquery.newContext(AccessContext.INTERNAL_PREFIX_LOOKUP);
            if (collection != null) {
                context.declareVariable(COLLECTION, collection);
            }
            if (namespace != null) {
                context.declareVariable(TARGETNAMESPACE, namespace);
            }
            if (publicId != null) {
                context.declareVariable(PUBLICID, publicId);
            }
            if (catalogPath != null) {
                context.declareVariable(CATALOG, catalogPath);
            }
            compiled = xquery.compile(context, new ClassLoaderSource(queryPath));
            result = xquery.execute(compiled, null);
        }
        catch (Exception ex) {
            logger.error((Object)"Problem executing xquery", (Throwable)ex);
            result = null;
        }
        finally {
            if (this.brokerPool != null) {
                this.brokerPool.release(broker);
            }
        }
        return result;
    }

    public DatabaseResources(BrokerPool pool) {
        logger.info((Object)"Initializing DatabaseResources");
        this.brokerPool = pool;
    }

    public String findXSD(String collection, String targetNamespace, User user) {
        logger.debug((Object)("Find schema with namespace '" + targetNamespace + "' in '" + collection + "'."));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COLLECTION, collection);
        params.put(TARGETNAMESPACE, targetNamespace);
        Sequence result = this.executeQuery(FIND_XSD, params, user);
        return this.getFirstResult(result);
    }

    public String findCatalogWithDTD(String collection, String publicId, User user) {
        logger.debug((Object)("Find DTD with public '" + publicId + "' in '" + collection + "'."));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COLLECTION, collection);
        params.put(PUBLICID, publicId);
        Sequence result = this.executeQuery(FIND_CATALOGS_WITH_DTD, params, user);
        return this.getFirstResult(result);
    }
}

