/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal.node;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.storage.io.ExistIOException;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.SequenceIterator;

public class NodeSerializer {
    private static final Logger LOG = Logger.getLogger((Class)NodeSerializer.class);

    public static void serialize(XQueryContext context, SequenceIterator siNode, Properties outputProperties, OutputStream os) throws IOException {
        LOG.debug((Object)"Serializing started.");
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        try {
            String encoding = outputProperties.getProperty("encoding", "UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
            sax.setOutput(writer, outputProperties);
            Serializer serializer = context.getBroker().getSerializer();
            serializer.reset();
            serializer.setProperties(outputProperties);
            serializer.setReceiver(sax);
            sax.startDocument();
            while (siNode.hasNext()) {
                NodeValue next = (NodeValue)siNode.nextItem();
                serializer.toSAX(next);
            }
            sax.endDocument();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            String txt = "A problem ocurred while serializing the node set";
            LOG.debug((Object)(txt + "."), (Throwable)e);
            throw new ExistIOException(txt + ": " + e.getMessage(), e);
        }
        finally {
            LOG.debug((Object)"Serializing done.");
            SerializerPool.getInstance().returnObject(sax);
        }
    }
}

