/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.File;
import org.apache.log4j.Logger;

public class JnlpHelper {
    private static final String LIB_CORE = "../lib/core";
    private static final String LIB_EXIST = "..";
    private static final String LIB_WEBINF = "WEB-INF/lib/";
    private static Logger logger = Logger.getLogger((Class)JnlpHelper.class);
    private File coreJarsFolder = null;
    private File existJarFolder = null;
    private File webappsFolder = null;

    private boolean isInWarFile(File existHome) {
        return !new File(existHome, LIB_CORE).isDirectory();
    }

    public JnlpHelper(File contextRoot) {
        if (this.isInWarFile(contextRoot)) {
            logger.debug((Object)"eXist is running in servlet container (.war).");
            this.existJarFolder = this.coreJarsFolder = new File(contextRoot, LIB_WEBINF);
            this.webappsFolder = contextRoot;
        } else {
            logger.debug((Object)"eXist is running private jetty server.");
            this.coreJarsFolder = new File(contextRoot, LIB_CORE);
            this.existJarFolder = new File(contextRoot, LIB_EXIST);
            this.webappsFolder = contextRoot;
        }
        logger.debug((Object)("CORE jars location=" + this.coreJarsFolder.getAbsolutePath()));
        logger.debug((Object)("EXIST jars location=" + this.existJarFolder.getAbsolutePath()));
        logger.debug((Object)("WEBAPP location=" + this.webappsFolder.getAbsolutePath()));
    }

    public File getWebappFolder() {
        return this.webappsFolder;
    }

    public File getCoreJarsFolder() {
        return this.coreJarsFolder;
    }

    public File getExistJarFolder() {
        return this.existJarFolder;
    }
}

