/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.exist.EXistException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.ShutdownListener;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
implements Database {
    private static final Logger LOG = Logger.getLogger((Class)DatabaseImpl.class);
    protected static final String LOCAL_HOSTNAME = "";
    protected static final int UNKNOWN_CONNECTION = -1;
    protected static final int LOCAL_CONNECTION = 0;
    protected static final int REMOTE_CONNECTION = 1;
    public static final String CONF_XML = "conf.xml";
    protected boolean autoCreate = false;
    protected String configuration = null;
    protected String currentInstanceName = null;
    private HashMap rpcClients = new HashMap();
    protected ShutdownListener shutdown = null;
    protected int mode = -1;

    public DatabaseImpl() {
        String initdb = System.getProperty("exist.initdb");
        if (initdb != null) {
            this.autoCreate = initdb.equalsIgnoreCase("true");
        }
    }

    private void configure(String instanceName) throws XMLDBException {
        try {
            Configuration config = new Configuration(this.configuration, null);
            BrokerPool.configure(instanceName, 1, 5, config);
            if (this.shutdown != null) {
                BrokerPool.getInstance(instanceName).registerShutdownListener(this.shutdown);
            }
        }
        catch (Exception e) {
            throw new XMLDBException(1, "configuration error", (Throwable)e);
        }
        this.currentInstanceName = instanceName;
    }

    public boolean acceptsURI(String uri) throws XMLDBException {
        XmldbURI xmldbURI = null;
        try {
            String newURIString = XmldbURI.recoverPseudoURIs(uri);
            xmldbURI = XmldbURI.xmldbUriFor("xmldb:" + newURIString);
            return this.acceptsURI(xmldbURI);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(401, "xmldb URI is not well formed: xmldb:" + uri);
        }
    }

    public boolean acceptsURI(XmldbURI xmldbURI) throws XMLDBException {
        return true;
    }

    public Collection getCollection(String uri, String user, String password) throws XMLDBException {
        XmldbURI xmldbURI = null;
        try {
            String newURIString = XmldbURI.recoverPseudoURIs(uri);
            xmldbURI = XmldbURI.xmldbUriFor("xmldb:" + newURIString);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(401, "xmldb URI is not well formed: xmldb:" + uri);
        }
        return this.getCollection(xmldbURI, user, password);
    }

    public Collection getCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        if ("local".equals(xmldbURI.getApiName())) {
            return this.getLocalCollection(xmldbURI, user, password);
        }
        if ("xmlrpc".equals(xmldbURI.getApiName())) {
            return this.getRemoteCollection(xmldbURI, user, password);
        }
        throw new XMLDBException(401, "Unknown or unparsable API for: " + xmldbURI);
    }

    private Collection getLocalCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        BrokerPool pool;
        this.mode = 0;
        if (!BrokerPool.isConfigured(xmldbURI.getInstanceName())) {
            if (this.autoCreate) {
                this.configure(xmldbURI.getInstanceName());
            } else {
                throw new XMLDBException(202, "Local database server is not running");
            }
        }
        try {
            pool = BrokerPool.getInstance(xmldbURI.getInstanceName());
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "Can not access to local database instance", (Throwable)e);
        }
        User u = this.getUser(user, password, pool);
        try {
            LocalCollection current = new LocalCollection(u, pool, xmldbURI.toCollectionPathURI(), AccessContext.XMLDB);
            return current != null ? current : null;
        }
        catch (XMLDBException e) {
            switch (e.errorCode) {
                case 200: 
                case 201: 
                case 300: 
                case 301: {
                    LOG.info((Object)e.getMessage());
                    return null;
                }
            }
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Collection getRemoteCollection(XmldbURI xmldbURI, String user, String password) throws XMLDBException {
        this.mode = 1;
        if (user == null) {
            user = "guest";
            password = "guest";
        }
        if (password == null) {
            password = LOCAL_HOSTNAME;
        }
        try {
            URL url = new URL("http", xmldbURI.getHost(), xmldbURI.getPort(), xmldbURI.getContext());
            XmlRpcClient rpcClient = this.getRpcClient(user, password, url);
            return DatabaseImpl.readCollection(xmldbURI.getRawCollectionPath(), rpcClient);
        }
        catch (MalformedURLException e) {
            throw new XMLDBException(401, e.getMessage());
        }
        catch (XMLDBException e) {
            return null;
        }
    }

    public static Collection readCollection(String c, XmlRpcClient rpcClient) throws XMLDBException {
        XmldbURI path;
        try {
            path = XmldbURI.xmldbUriFor(c);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        XmldbURI[] components = path.getPathSegments();
        if (components.length == 0) {
            throw new XMLDBException(200, "Could not find collection: " + path.toString());
        }
        XmldbURI rootName = components[0];
        if (XmldbURI.RELATIVE_ROOT_COLLECTION_URI.equals(rootName)) {
            rootName = XmldbURI.ROOT_COLLECTION_URI;
        }
        RemoteCollection current = new RemoteCollection(rpcClient, null, rootName);
        for (int i = 1; i < components.length; ++i) {
            if ((current = current.getChildCollection(components[i])) != null) continue;
            throw new XMLDBException(200, "Could not find collection: " + c);
        }
        return current;
    }

    private User getUser(String user, String password, BrokerPool pool) throws XMLDBException {
        SecurityManager securityManager;
        User u;
        if (user == null) {
            user = "guest";
            password = "guest";
        }
        if ((u = (securityManager = pool.getSecurityManager()).getUser(user)) == null) {
            throw new XMLDBException(4, "User '" + user + "' does not exist");
        }
        if (!u.validate(password, securityManager)) {
            throw new XMLDBException(4, "Invalid password for user '" + user + "'");
        }
        return u;
    }

    private XmlRpcClient getRpcClient(String user, String password, URL url) throws XMLDBException {
        String key = user + "@" + url.toString();
        XmlRpcClient client = (XmlRpcClient)this.rpcClients.get(key);
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(true);
        config.setServerURL(url);
        config.setBasicUserName(user);
        config.setBasicPassword(password);
        if (client == null) {
            client = new XmlRpcClient();
            this.rpcClients.put(key, client);
        }
        client.setConfig((XmlRpcClientConfig)config);
        return client;
    }

    public void setDatabaseShutdownListener(ShutdownListener listener) throws XMLDBException {
        this.shutdown = listener;
    }

    public String getConformanceLevel() throws XMLDBException {
        return "0";
    }

    public String getName() throws XMLDBException {
        return this.currentInstanceName != null ? this.currentInstanceName : "exist";
    }

    public String[] getNames() throws XMLDBException {
        return new String[]{this.currentInstanceName != null ? this.currentInstanceName : "exist"};
    }

    public String getProperty(String property) throws XMLDBException {
        if (property.equals("create-database")) {
            return Boolean.valueOf(this.autoCreate).toString();
        }
        if (property.equals("database-id")) {
            return this.currentInstanceName;
        }
        if (property.equals("configuration")) {
            return this.configuration;
        }
        return null;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        if (property.equals("create-database")) {
            this.autoCreate = value.equals("true");
        }
        if (property.equals("database-id")) {
            this.currentInstanceName = value;
        }
        if (property.equals("configuration")) {
            this.configuration = value;
        }
    }
}

