/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Map;
import java.util.TreeMap;
import org.exist.storage.BrokerPool;
import org.exist.storage.IndexStats;
import org.exist.storage.report.Statistics;
import org.exist.util.Configuration;

public class DatabaseStatus {
    private String id;
    private String confPath;
    private String dataDir;
    private int runningBrokers = 0;
    private int availableBrokers = 0;
    private int maxBrokers = 0;
    private Map indexStats = new TreeMap();

    public DatabaseStatus(BrokerPool pool) {
        Configuration conf = pool.getConfiguration();
        this.id = pool.getId();
        this.dataDir = (String)conf.getProperty("db-connection.data-dir");
        this.runningBrokers = pool.active();
        this.availableBrokers = pool.available();
        this.maxBrokers = pool.getMax();
        Statistics.generateIndexStatistics(conf, this.indexStats);
    }

    public int getAvailableBrokers() {
        return this.availableBrokers;
    }

    public String getConfPath() {
        return this.confPath;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxBrokers() {
        return this.maxBrokers;
    }

    public int getRunningBrokers() {
        return this.runningBrokers;
    }

    public IndexStats getIndexStats(String dbName) {
        return (IndexStats)this.indexStats.get(dbName);
    }
}

