/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.security.Permission;
import org.exist.security.UnixStylePermission;
import org.exist.security.User;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class RemoteUserManagementService
implements UserManagementService {
    private RemoteCollection parent;

    public RemoteUserManagementService(RemoteCollection collection) {
        this.parent = collection;
    }

    public void addUser(User user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(12);
            params.add(user.getName());
            params.add(user.getPassword() == null ? "" : user.getPassword());
            params.add(user.getDigestPassword() == null ? "" : user.getDigestPassword());
            String[] gl = user.getGroups();
            params.add(gl);
            if (user.getHome() != null) {
                params.add(user.getHome().toString());
            }
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setPermissions(Resource res, Permission perms) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<Object> params = new ArrayList<Object>(1);
            params.add(path);
            params.add(perms.getOwner());
            params.add(perms.getOwnerGroup());
            params.add(new Integer(perms.getPermissions()));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setPermissions(Collection child, Permission perms) throws XMLDBException {
        String path = ((RemoteCollection)child).getPath();
        try {
            ArrayList<Object> params = new ArrayList<Object>(4);
            params.add(path);
            params.add(perms.getOwner());
            params.add(perms.getOwnerGroup());
            params.add(new Integer(perms.getPermissions()));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(Resource res, String mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(path);
            params.add(mode);
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(Resource res, int mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(path);
            params.add(new Integer(mode));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(String mode) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(this.parent.getPath());
            params.add(mode);
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(int mode) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(this.parent.getPath());
            params.add(new Integer(mode));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void lockResource(Resource res, User u) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(path);
            params.add(u.getName());
            this.parent.getClient().execute("lockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String hasUserLock(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(path);
            String userName = (String)this.parent.getClient().execute("hasUserLock", params);
            return userName != null && userName.length() > 0 ? userName : null;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void unlockResource(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(path);
            this.parent.getClient().execute("unlockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chown(User u, String group) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(4);
            params.add(this.parent.getPath());
            params.add(u.getName());
            params.add(group);
            params.add("");
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chown(Resource res, User u, String group) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        try {
            ArrayList<String> params = new ArrayList<String>(4);
            params.add(path);
            params.add(u.getName());
            params.add(group);
            params.add("");
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return "UserManagementService";
    }

    public Permission getPermissions(Collection coll) throws XMLDBException {
        if (coll == null) {
            throw new XMLDBException(301, "collection is null");
        }
        Permission perm = ((RemoteCollection)coll).getPermissions();
        if (perm != null) {
            return perm;
        }
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(((RemoteCollection)coll).getPath());
            HashMap result = (HashMap)this.parent.getClient().execute("getPermissions", params);
            perm = new UnixStylePermission((String)result.get("owner"), (String)result.get("group"), (Integer)result.get("permissions"));
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission getPermissions(Resource res) throws XMLDBException {
        if (res == null) {
            throw new XMLDBException(301, "resource is null");
        }
        if (((EXistResource)res).getPermissions() != null) {
            return ((EXistResource)res).getPermissions();
        }
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + "/" + res.getId();
        System.out.println("Retrieving permissions for " + path);
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(path);
            HashMap result = (HashMap)this.parent.getClient().execute("getPermissions", params);
            UnixStylePermission perm = new UnixStylePermission((String)result.get("owner"), (String)result.get("group"), (Integer)result.get("permissions"));
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission[] listResourcePermissions() throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(this.parent.getPath());
            HashMap result = (HashMap)this.parent.getClient().execute("listDocumentPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] resources = this.parent.listResources();
            for (int i = 0; i < resources.length; ++i) {
                Object[] t = (Object[])result.get(resources[i]);
                perm[i] = new UnixStylePermission();
                perm[i].setOwner((String)t[0]);
                perm[i].setGroup((String)t[1]);
                perm[i].setPermissions((Integer)t[2]);
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission[] listCollectionPermissions() throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(this.parent.getPath());
            HashMap result = (HashMap)this.parent.getClient().execute("listCollectionPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] collections = this.parent.listChildCollections();
            for (int i = 0; i < collections.length; ++i) {
                Object[] t = (Object[])result.get(collections[i]);
                perm[i] = new UnixStylePermission();
                perm[i].setOwner((String)t[0]);
                perm[i].setGroup((String)t[1]);
                perm[i].setPermissions((Integer)t[2]);
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getProperty(String property) throws XMLDBException {
        return null;
    }

    public User getUser(String name) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(name);
            HashMap tab = (HashMap)this.parent.getClient().execute("getUser", params);
            User u = new User((String)tab.get("name"), null);
            Object[] groups = (Object[])tab.get("groups");
            for (int i = 0; i < groups.length; ++i) {
                u.addGroup((String)groups[i]);
            }
            String home = (String)tab.get("home");
            u.setHome(home == null ? null : XmldbURI.create(home));
            return u;
        }
        catch (XmlRpcException e) {
            return null;
        }
    }

    public User[] getUsers() throws XMLDBException {
        try {
            Object[] users = (Object[])this.parent.getClient().execute("getUsers", new ArrayList());
            User[] u = new User[users.length];
            for (int i = 0; i < u.length; ++i) {
                HashMap tab = (HashMap)users[i];
                u[i] = new User((String)tab.get("name"), null);
                Object[] groups = (Object[])tab.get("groups");
                for (int j = 0; j < groups.length; ++j) {
                    u[i].addGroup((String)groups[j]);
                }
                String home = (String)tab.get("home");
                u[i].setHome(home == null ? null : XmldbURI.create(home));
            }
            return u;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getVersion() {
        return "1.0";
    }

    public void removeUser(User u) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(u.getName());
            this.parent.getClient().execute("removeUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
        this.parent = (RemoteCollection)collection;
    }

    public void setProperty(String property, String value) throws XMLDBException {
    }

    public void updateUser(User user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(12);
            params.add(user.getName());
            params.add(user.getPassword() == null ? "" : user.getPassword());
            params.add(user.getDigestPassword() == null ? "" : user.getDigestPassword());
            String[] gl = user.getGroups();
            params.add(gl);
            if (user.getHome() != null) {
                params.add(user.getHome().toString());
            }
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void addUserGroup(User user) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(3);
            params.add(user.getName());
            String[] gl = user.getGroups();
            params.add(gl);
            if (user.getHome() != null) {
                params.add(user.getHome());
            }
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void removeGroup(User user, String rmgroup) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(1);
            params.add(user.getName());
            String[] gl = user.getGroups();
            params.add(gl);
            if (user.getHome() != null) {
                params.add(user.getHome());
            }
            params.add(rmgroup);
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String[] getGroups() throws XMLDBException {
        try {
            Object[] v = (Object[])this.parent.getClient().execute("getGroups", new ArrayList());
            String[] groups = new String[v.length];
            System.arraycopy(v, 0, groups, 0, v.length);
            return groups;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }
}

