/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.source.Source;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteCompiledExpression;
import org.exist.xmldb.RemoteResourceSet;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.exist.xmldb.XQueryService;
import org.exist.xquery.XPathException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class RemoteXPathQueryService
implements XPathQueryServiceImpl,
XQueryService {
    protected RemoteCollection collection;
    protected HashMap namespaceMappings = new HashMap(5);
    protected HashMap variableDecls = new HashMap();
    protected Properties outputProperties = null;
    protected boolean protectedMode = false;

    public RemoteXPathQueryService(RemoteCollection collection) {
        this.collection = collection;
        this.outputProperties = new Properties(collection.properties);
    }

    public ResourceSet query(String query) throws XMLDBException {
        return this.query(query, null);
    }

    public ResourceSet query(String query, String sortExpr) throws XMLDBException {
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (sortExpr != null) {
                optParams.put("sort-expr", sortExpr);
            }
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            if (this.protectedMode) {
                optParams.put("protected", this.collection.getPath());
            }
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(query.getBytes("UTF-8"));
            params.add(optParams);
            HashMap result = (HashMap)this.collection.getClient().execute("queryP", params);
            if (result.get("error") != null) {
                this.throwException(result);
            }
            Object[] resources = (Object[])result.get("results");
            int handle = -1;
            if (resources != null && resources.length > 0) {
                handle = (Integer)result.get("id");
            }
            return new RemoteResourceSet(this.collection, this.outputProperties, resources, handle);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public CompiledExpression compile(String query) throws XMLDBException {
        try {
            return this.compileAndCheck(query);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public CompiledExpression compileAndCheck(String query) throws XMLDBException, XPathException {
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(query.getBytes("UTF-8"));
            params.add(optParams);
            HashMap result = (HashMap)this.collection.getClient().execute("compile", params);
            if (result.get("error") != null) {
                this.throwXPathException(result);
            }
            return new RemoteCompiledExpression(query);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    private void throwException(HashMap result) throws XMLDBException {
        String message = (String)result.get("error");
        Integer lineInt = (Integer)result.get("line");
        Integer columnInt = (Integer)result.get("column");
        int line = lineInt == null ? 0 : lineInt;
        int column = columnInt == null ? 0 : columnInt;
        XPathException cause = new XPathException(message, line, column);
        throw new XMLDBException(1, message, (Throwable)cause);
    }

    private void throwXPathException(HashMap result) throws XPathException {
        String message = (String)result.get("error");
        Integer lineInt = (Integer)result.get("line");
        Integer columnInt = (Integer)result.get("column");
        int line = lineInt == null ? 0 : lineInt;
        int column = columnInt == null ? 0 : columnInt;
        throw new XPathException(message, line, column);
    }

    public ResourceSet execute(Source source) throws XMLDBException {
        try {
            String xq = source.getContent();
            return this.query(xq, null);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public ResourceSet query(XMLResource res, String query) throws XMLDBException {
        return this.query(res, query, null);
    }

    public ResourceSet query(XMLResource res, String query, String sortExpr) throws XMLDBException {
        RemoteXMLResource resource = (RemoteXMLResource)res;
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            if (sortExpr != null) {
                optParams.put("sort-expr", sortExpr);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            if (this.protectedMode) {
                optParams.put("protected", this.collection.getPath());
            }
            ArrayList<Object> params = new ArrayList<Object>(5);
            params.add(query.getBytes("UTF-8"));
            params.add(resource.path.toString());
            if (resource.id == null) {
                params.add("");
            } else {
                params.add(resource.id);
            }
            params.add(optParams);
            HashMap result = (HashMap)this.collection.getClient().execute("queryP", params);
            if (result.get("error") != null) {
                this.throwException(result);
            }
            Object[] resources = (Object[])result.get("results");
            int handle = -1;
            if (resources != null && resources.length > 0) {
                handle = (Integer)result.get("id");
            }
            return new RemoteResourceSet(this.collection, this.outputProperties, resources, handle);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public ResourceSet queryResource(String resource, String query) throws XMLDBException {
        Resource res = this.collection.getResource(resource);
        if (res == null) {
            throw new XMLDBException(301, "Resource " + resource + " not found");
        }
        if (!"XMLResource".equals(res.getResourceType())) {
            throw new XMLDBException(301, "Resource " + resource + " is not an XML resource");
        }
        return this.query((XMLResource)res, query);
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
    }

    public String getName() throws XMLDBException {
        return "XPathQueryService";
    }

    public String getProperty(String property) throws XMLDBException {
        return this.outputProperties.getProperty(property);
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.outputProperties.setProperty(property, value);
    }

    public void clearNamespaces() throws XMLDBException {
        this.namespaceMappings.clear();
    }

    public void removeNamespace(String ns) throws XMLDBException {
        Iterator i = this.namespaceMappings.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(ns)) continue;
            i.remove();
        }
    }

    public void setNamespace(String prefix, String namespace) throws XMLDBException {
        if (prefix == null) {
            prefix = "";
        }
        this.namespaceMappings.put(prefix, namespace);
    }

    public String getNamespace(String prefix) throws XMLDBException {
        if (prefix == null) {
            prefix = "";
        }
        return (String)this.namespaceMappings.get(prefix);
    }

    public void declareVariable(String qname, Object initialValue) throws XMLDBException {
        this.variableDecls.put(qname, initialValue);
    }

    public ResourceSet execute(CompiledExpression expression) throws XMLDBException {
        return this.query(((RemoteCompiledExpression)expression).getQuery());
    }

    public ResourceSet execute(XMLResource res, CompiledExpression expression) throws XMLDBException {
        return this.query(res, ((RemoteCompiledExpression)expression).getQuery());
    }

    public void setXPathCompatibility(boolean backwardsCompatible) {
    }

    public void setModuleLoadPath(String path) {
    }

    public void dump(CompiledExpression expression, Writer writer) throws XMLDBException {
        String query = ((RemoteCompiledExpression)expression).getQuery();
        HashMap<String, Object> optParams = new HashMap<String, Object>();
        if (this.namespaceMappings.size() > 0) {
            optParams.put("namespaces", this.namespaceMappings);
        }
        if (this.variableDecls.size() > 0) {
            optParams.put("variables", this.variableDecls);
        }
        optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(query);
        params.add(optParams);
        try {
            String dump = (String)this.collection.getClient().execute("printDiagnostics", params);
            writer.write(dump);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public void beginProtected() {
        this.protectedMode = true;
    }

    public void endProtected() {
        this.protectedMode = false;
    }
}

