/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfig;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.exist.EXistException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.xmlrpc.QueryResultCache;
import org.exist.xmlrpc.RpcConnection;

public class XmldbRequestProcessorFactory
implements RequestProcessorFactoryFactory.RequestProcessorFactory {
    private static final Logger LOG = Logger.getLogger((Class)XmldbRequestProcessorFactory.class);
    public static final int CHECK_INTERVAL = 400;
    protected BrokerPool brokerPool;
    protected int connections = 0;
    protected long lastCheck = System.currentTimeMillis();
    protected QueryResultCache resultSets = new QueryResultCache();
    protected String databaseid = "exist";

    public XmldbRequestProcessorFactory(String databaseid) throws EXistException {
        if (databaseid != null && !"".equals(databaseid)) {
            this.databaseid = databaseid;
        }
        this.brokerPool = BrokerPool.getInstance(this.databaseid);
    }

    public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
        this.checkResultSets();
        XmlRpcHttpRequestConfig config = (XmlRpcHttpRequestConfig)pRequest.getConfig();
        User user = this.authenticate(config.getBasicUserName(), config.getBasicPassword());
        return new RpcConnection(this, user);
    }

    protected User authenticate(String username, String password) throws XmlRpcException {
        User u;
        if (username == null) {
            username = "guest";
            password = "guest";
        }
        if ((u = this.brokerPool.getSecurityManager().getUser(username)) == null) {
            throw new XmlRpcException(0, "User " + username + " unknown");
        }
        if (!u.validate(password)) {
            LOG.debug((Object)("login denied for user " + username));
            throw new XmlRpcException(0, "Invalid password for user " + username);
        }
        return u;
    }

    protected BrokerPool getBrokerPool() {
        return this.brokerPool;
    }

    protected void checkResultSets() {
        if (System.currentTimeMillis() - this.lastCheck > 400L) {
            this.resultSets.checkTimestamps();
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public synchronized void shutdown() {
        try {
            BrokerPool.stop();
        }
        catch (EXistException e) {
            LOG.warn((Object)"shutdown failed", (Throwable)e);
        }
    }
}

