/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class AbstractExpression
implements Expression {
    private int expressionId = -1;
    protected XQueryContext context;
    protected XQueryAST astNode = null;
    protected DocumentSet contextDocSet = null;
    protected int contextId = -1;

    public AbstractExpression(XQueryContext context) {
        this.context = context;
        this.expressionId = context.nextExpressionId();
    }

    public int getExpressionId() {
        return this.expressionId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public Sequence eval(Sequence contextSequence) throws XPathException {
        return this.eval(contextSequence, null);
    }

    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public abstract int returnsType();

    public void resetState(boolean postOptimization) {
        this.contextDocSet = null;
    }

    public int getCardinality() {
        return 2;
    }

    public int getDependencies() {
        return 1;
    }

    public void setPrimaryAxis(int axis) {
    }

    public void setContextDocSet(DocumentSet contextSet) {
        this.contextDocSet = contextSet;
    }

    public DocumentSet getContextDocSet() {
        return this.contextDocSet;
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void setASTNode(XQueryAST ast) {
        this.astNode = ast;
    }

    public XQueryAST getASTNode() {
        return this.astNode;
    }
}

