/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CachedResult {
    protected final Sequence cachedResult;
    protected final Sequence cachedContext;
    protected final Item cachedItem;
    protected final int timestamp;

    public CachedResult(Sequence context, Item contextItem, Sequence result) {
        this.cachedContext = context;
        this.cachedResult = result;
        this.cachedItem = contextItem;
        this.timestamp = context.getState();
    }

    public Sequence getResult() {
        return this.cachedResult;
    }

    public boolean isValid(Sequence context, Item contextItem) {
        if (context == null) {
            return false;
        }
        if (Type.subTypeOf(context.getItemType(), -1) && this.cachedContext == context && this.cachedItem == contextItem) {
            if (context.hasChanged(this.timestamp)) {
                return false;
            }
            this.cachedResult.setIsCached(true);
            return true;
        }
        return false;
    }
}

