/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public abstract class DeferredFunctionCall
implements Sequence {
    private static final Logger LOG = Logger.getLogger((Class)DeferredFunctionCall.class);
    private FunctionSignature signature;
    private Sequence sequence = null;

    protected DeferredFunctionCall(FunctionSignature signature) {
        this.signature = signature;
    }

    private void realize() throws XPathException {
        if (this.sequence == null) {
            this.sequence = this.execute();
        }
    }

    protected FunctionSignature getSignature() {
        return this.signature;
    }

    protected abstract Sequence execute() throws XPathException;

    public void add(Item item) throws XPathException {
        this.realize();
        this.sequence.add(item);
    }

    public void addAll(Sequence other) throws XPathException {
        this.realize();
        this.sequence.addAll(other);
    }

    public void clearContext(int contextId) {
        if (this.sequence != null) {
            this.sequence.clearContext(contextId);
        }
    }

    public int conversionPreference(Class javaClass) {
        if (this.sequence != null) {
            return this.sequence.conversionPreference(javaClass);
        }
        return Integer.MAX_VALUE;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        this.realize();
        return this.sequence.convertTo(requiredType);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        this.realize();
        return this.sequence.effectiveBooleanValue();
    }

    public int getCardinality() {
        try {
            this.realize();
            return this.sequence.getCardinality();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return 0;
        }
    }

    public DocumentSet getDocumentSet() {
        try {
            this.realize();
            return this.sequence.getDocumentSet();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return null;
        }
    }

    public Iterator getCollectionIterator() {
        try {
            this.realize();
            return this.sequence.getCollectionIterator();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return null;
        }
    }

    public int getItemType() {
        try {
            this.realize();
            return this.sequence.getItemType();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return 12;
        }
    }

    public int getItemCount() {
        try {
            this.realize();
            return this.sequence.getItemCount();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return 0;
        }
    }

    public String getStringValue() throws XPathException {
        this.realize();
        return this.sequence.getStringValue();
    }

    public boolean hasMany() {
        try {
            this.realize();
            return this.sequence.hasMany();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return false;
        }
    }

    public boolean hasOne() {
        try {
            this.realize();
            return this.sequence.hasOne();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return false;
        }
    }

    public boolean isCached() {
        try {
            this.realize();
            return this.sequence.isCached();
        }
        catch (XPathException e) {
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            this.realize();
            return this.sequence.isEmpty();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return false;
        }
    }

    public boolean isPersistentSet() {
        try {
            this.realize();
            return this.sequence.isPersistentSet();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return false;
        }
    }

    public Item itemAt(int pos) {
        try {
            this.realize();
            return this.sequence.itemAt(pos);
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return null;
        }
    }

    public SequenceIterator iterate() throws XPathException {
        this.realize();
        return this.sequence.iterate();
    }

    public void removeDuplicates() {
        try {
            this.realize();
            this.sequence.removeDuplicates();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
        }
    }

    public void setIsCached(boolean cached) {
        try {
            this.realize();
            this.sequence.setIsCached(cached);
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
        }
    }

    public void setSelfAsContext(int contextId) {
        try {
            this.realize();
            this.sequence.setSelfAsContext(contextId);
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
        }
    }

    public Object toJavaObject(Class target) throws XPathException {
        this.realize();
        return this.sequence.toJavaObject(target);
    }

    public NodeSet toNodeSet() throws XPathException {
        this.realize();
        return this.sequence.toNodeSet();
    }

    public SequenceIterator unorderedIterator() {
        try {
            this.realize();
            return this.sequence.unorderedIterator();
        }
        catch (XPathException e) {
            LOG.error((Object)("Exception in deferred function: " + e.getMessage()));
            return null;
        }
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
    }

    public int getState() {
        return 0;
    }

    public boolean hasChanged(int previousState) {
        return true;
    }

    public boolean isCacheable() {
        return false;
    }
}

