/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class NamespaceConstructor
extends NodeConstructor {
    private final String prefix;
    private Expression uri = null;

    public NamespaceConstructor(XQueryContext context, String prefix) {
        super(context);
        this.prefix = prefix;
    }

    public void setURIExpression(Expression uriExpr) {
        this.uri = new Atomize(this.context, uriExpr);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.uri.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String value;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence uriSeq = this.uri.eval(contextSequence, contextItem);
        if (uriSeq.isEmpty()) {
            value = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = uriSeq.iterate();
            while (i.hasNext()) {
                this.context.proceed(this, builder);
                Item next = i.nextItem();
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(next.toString());
            }
            value = buf.toString();
        }
        this.context.declareInScopeNamespace(this.prefix, value);
        int nodeNr = builder.namespaceNode(this.prefix, value);
        NodeImpl result = builder.getDocument().getNamespaceNode(nodeNr);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("namespace ").display(this.prefix);
        dumper.display("{");
        this.uri.dump(dumper);
        dumper.display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("namespace ").append(this.prefix);
        result.append("{");
        result.append(this.uri.toString());
        result.append("}");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.uri.resetState(postOptimization);
    }
}

