/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import javax.xml.stream.XMLStreamReader;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.NodeTest;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class TypeTest
implements NodeTest {
    protected int nodeType = 0;

    public TypeTest(int nodeType) {
        this.setType(nodeType);
    }

    public void setType(int nodeType) {
        this.nodeType = nodeType;
    }

    public int getType() {
        return this.nodeType;
    }

    public QName getName() {
        return null;
    }

    protected boolean isOfType(short type) {
        short domType;
        switch (this.nodeType) {
            case 1: {
                domType = 1;
                break;
            }
            case 3: {
                domType = 3;
                break;
            }
            case 2: {
                domType = 2;
                break;
            }
            case 5: {
                domType = 8;
                break;
            }
            case 4: {
                domType = 7;
                break;
            }
            default: {
                return true;
            }
        }
        if (type == 4) {
            type = (short)3;
        }
        return type == domType;
    }

    protected boolean isOfEventType(int type) {
        int xpathType;
        if (this.nodeType == -1) {
            return true;
        }
        switch (type) {
            case 1: {
                xpathType = 1;
                break;
            }
            case 10: {
                xpathType = 2;
                break;
            }
            case 4: 
            case 12: {
                xpathType = 3;
                break;
            }
            case 5: {
                xpathType = 5;
                break;
            }
            case 3: {
                xpathType = 4;
                break;
            }
            default: {
                return false;
            }
        }
        return xpathType == this.nodeType;
    }

    public String toString() {
        return this.nodeType == -1 ? "node()" : Type.NODETYPES[this.nodeType] + "()";
    }

    public boolean matches(NodeProxy proxy) {
        short otherNodeType = proxy.getNodeType();
        if (otherNodeType == 11 || otherNodeType == -1) {
            if (this.nodeType == -1) {
                return true;
            }
            return this.isOfType(proxy.getNode().getNodeType());
        }
        return this.isOfType(otherNodeType);
    }

    public boolean matches(Node other) {
        if (other == null) {
            return false;
        }
        return this.isOfType(other.getNodeType());
    }

    public boolean matches(XMLStreamReader reader) {
        return this.isOfEventType(reader.getEventType());
    }

    public boolean isWildcardTest() {
        return true;
    }
}

