/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class UserDefinedFunction
extends Function {
    private Expression body;
    private List parameters = new ArrayList(5);
    private Sequence[] currentArguments = null;
    private DocumentSet[] contextDocs = null;
    private boolean inRecursion = false;

    public UserDefinedFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setFunctionBody(Expression body) {
        this.body = body;
    }

    public Expression getFunctionBody() {
        return this.body;
    }

    public void addVariable(String varName) throws XPathException {
        QName qname = QName.parse(this.context, varName, null);
        this.parameters.add(qname);
    }

    public void setArguments(Sequence[] args, DocumentSet[] contextDocs) throws XPathException {
        this.currentArguments = args;
        this.contextDocs = contextDocs;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (!this.inRecursion) {
            this.inRecursion = true;
            LocalVariable mark = this.context.markLocalVariables(true);
            Iterator i = this.parameters.iterator();
            while (i.hasNext()) {
                QName varName = (QName)i.next();
                LocalVariable var = new LocalVariable(varName);
                this.context.declareVariableBinding(var);
            }
            contextInfo.setParent(this);
            this.body.analyze(contextInfo);
            this.context.popLocalVariables(mark);
            this.inRecursion = false;
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        LocalVariable mark = this.context.markLocalVariables(true);
        int j = 0;
        int i = 0;
        while (i < this.parameters.size()) {
            QName varName = (QName)this.parameters.get(i);
            LocalVariable var = new LocalVariable(varName);
            var.setValue(this.currentArguments[j]);
            if (this.contextDocs != null) {
                var.setContextDocs(this.contextDocs[i]);
            }
            this.context.declareVariableBinding(var);
            int actualCardinality = this.currentArguments[j].isEmpty() ? 1 : (this.currentArguments[j].hasMany() ? 4 : 2);
            if (!Cardinality.checkCardinality(this.getSignature().getArgumentTypes()[j].getCardinality(), actualCardinality)) {
                throw new XPathException(this.getASTNode(), "Invalid cardinality for parameter $" + varName + ". Expected " + Cardinality.getDescription(this.getSignature().getArgumentTypes()[j].getCardinality()) + ", got " + this.currentArguments[j].getItemCount());
            }
            ++i;
            ++j;
        }
        Sequence result = this.body.eval(contextSequence, contextItem);
        this.context.popLocalVariables(mark);
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        FunctionSignature signature = this.getSignature();
        dumper.display(signature.getName());
        dumper.display('(');
        for (int i = 0; i < signature.getArgumentTypes().length; ++i) {
            if (i > 0) {
                dumper.display(", ");
            }
            dumper.display(signature.getArgumentTypes()[i]);
        }
        dumper.display(") ");
        dumper.display(signature.getReturnType().toString());
    }

    public String toString() {
        FunctionSignature signature = this.getSignature();
        StringBuffer buf = new StringBuffer();
        buf.append(signature.getName());
        buf.append('(');
        for (int i = 0; i < signature.getArgumentTypes().length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(signature.getArgumentTypes()[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    public int getDependencies() {
        return 19;
    }

    public void resetState(boolean postOptimization) {
        if (!this.inRecursion) {
            this.inRecursion = true;
            this.body.resetState(postOptimization);
            this.inRecursion = false;
        }
        if (!postOptimization) {
            this.currentArguments = null;
            this.contextDocs = null;
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitUserFunction(this);
    }

    public List getParameters() {
        return this.parameters;
    }
}

