/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunAdjustTimezone
extends BasicFunction {
    public static final FunctionSignature[] fnAdjustDateTimeToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-dateTime-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:dateTime value to the implicit timezone of the current locale.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(50, 3)), new FunctionSignature(new QName("adjust-dateTime-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:dateTime value to a specific timezone, or to no timezone at all. If $b is the empty sequence, returns an xs:dateTime without a timezone.", new SequenceType[]{new SequenceType(50, 3), new SequenceType(55, 3)}, new SequenceType(50, 3))};
    public static final FunctionSignature[] fnAdjustDateToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-date-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:date value to the implicit timezone of the current locale.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(51, 3)), new FunctionSignature(new QName("adjust-date-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:date value to a specific timezone, or to no timezone at all. If $b is the empty sequence, returns an xs:date without a timezone.", new SequenceType[]{new SequenceType(51, 3), new SequenceType(55, 3)}, new SequenceType(51, 3))};
    public static final FunctionSignature[] fnAdjustTimeToTimezone = new FunctionSignature[]{new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:time value to the implicit timezone of the current locale.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(52, 3)), new FunctionSignature(new QName("adjust-time-to-timezone", "http://www.w3.org/2005/xpath-functions"), "Adjusts an xs:time value to a specific timezone, or to no timezone at all. If $b is the empty sequence, returns an xs:time without a timezone.", new SequenceType[]{new SequenceType(52, 3), new SequenceType(55, 3)}, new SequenceType(52, 3))};

    public FunAdjustTimezone(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            AbstractDateTimeValue time = (AbstractDateTimeValue)args[0].itemAt(0);
            if (this.getSignature().getArgumentCount() == 2) {
                if (args[1].isEmpty()) {
                    result = time.withoutTimezone();
                } else {
                    DayTimeDurationValue offset = (DayTimeDurationValue)args[1].itemAt(0);
                    result = time.adjustedToTimezone(offset);
                }
            } else {
                result = time.adjustedToTimezone(null);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

