/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunLocalName
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("local-name", "http://www.w3.org/2005/xpath-functions"), "Returns the local part of the name of the context item as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName.", new SequenceType[0], new SequenceType(22, 2)), new FunctionSignature(new QName("local-name", "http://www.w3.org/2005/xpath-functions"), "Returns the local part of the name of the value of $a as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(22, 2))};

    public FunLocalName(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Item item = null;
        if (this.getArgumentCount() > 0) {
            Sequence seq = this.getArgument(0).eval(contextSequence);
            if (!seq.isEmpty()) {
                item = seq.itemAt(0);
            }
        } else {
            if (contextSequence == null || contextSequence.isEmpty()) {
                throw new XPathException(this.getASTNode(), "XPDY0002: Undefined context item");
            }
            item = contextSequence.itemAt(0);
        }
        if (item == null) {
            result = StringValue.EMPTY_STRING;
        } else {
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            result = new StringValue(n.getLocalName());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

