/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunName
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("name", "http://www.w3.org/2005/xpath-functions"), "Returns the name of a node, as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName", new SequenceType[0], new SequenceType(22, 3)), new FunctionSignature(new QName("name", "http://www.w3.org/2005/xpath-functions"), "Returns the name of a node, as an xs:string that is either the zero-length string, or has the lexical form of an xs:QName", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(22, 3))};

    public FunName(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException(this.getASTNode(), "XPDY0002: Undefined context item");
        }
        if (seq.isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            Item item = seq.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            result = n instanceof QNameable ? new StringValue(((QNameable)((Object)n)).getQName().getStringValue()) : StringValue.EMPTY_STRING;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

