/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunNamespaceURI
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("namespace-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of the xs:QName of the context item. If the context item is in no namespace or is neither an element nor attribute node, returns the xs:anyURI eqvivalent to the zero-length string. Raises an error if the context item is undefined or not a node.", new SequenceType[0], new SequenceType(25, 2), false), new FunctionSignature(new QName("namespace-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of the xs:QName value of $aIf $a is in no namespace or is neither an element nor attribute node, returns the xs:anyURI eqvivalent to the zero-length string. Raises an error if the context item is undefined or not a node.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(25, 2), false)};

    public FunNamespaceURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        AnyURIValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Item item = null;
        if (this.getArgumentCount() > 0) {
            Sequence seq = this.getArgument(0).eval(contextSequence);
            if (!seq.isEmpty()) {
                item = seq.itemAt(0);
            }
        } else {
            if (contextItem == null) {
                throw new XPathException(this.getASTNode(), "XPDY0002: Undefined context item");
            }
            item = contextItem;
        }
        if (item == null) {
            result = AnyURIValue.EMPTY_URI;
        } else {
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPDY0004: Context item is not a node; got: " + Type.getTypeName(item.getType()));
            }
            Node n = ((NodeValue)item).getNode();
            result = new AnyURIValue(n.getNamespaceURI());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

