/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunMatches;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunReplace
extends FunMatches {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("replace", "http://www.w3.org/2005/xpath-functions"), "The function returns the xs:string that is obtained by replacing all non-overlapping substrings of $a that match the given pattern $b with an occurrence of the $c replacement string.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 3)), new FunctionSignature(new QName("replace", "http://www.w3.org/2005/xpath-functions"), "The function returns the xs:string that is obtained by replacing all non-overlapping substrings of $a that match the given pattern $b with an occurrence of the $c replacement string.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 3))};

    public FunReplace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setArguments(List arguments) throws XPathException {
        Expression arg = (Expression)arguments.get(0);
        if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 3, arg, new Error("D02", "1", this.mySignature))).returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        arg = (Expression)arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "2", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        arg = (Expression)arguments.get(2);
        arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "3", this.mySignature));
        if (!Type.subTypeOf(arg.returnsType(), 20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
        if (arguments.size() == 4) {
            arg = (Expression)arguments.get(3);
            if (!Type.subTypeOf((arg = new DynamicCardinalityCheck(this.context, 2, arg, new Error("D02", "4", this.mySignature))).returnsType(), 20)) {
                arg = new Atomize(this.context, arg);
            }
            this.steps.add(arg);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence stringArg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((stringArg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String string = stringArg.getStringValue();
            String pattern = this.translateRegexp(this.getArgument(1).eval(contextSequence, contextItem).getStringValue());
            String replace = ((StringValue)this.getArgument(2).eval(contextSequence, contextItem)).getStringValue(true);
            for (int i = 0; i < replace.length(); ++i) {
                if (replace.charAt(i) != '\\') continue;
                try {
                    if (replace.charAt(i + 1) != '\\' && replace.charAt(i + 1) != '$') {
                        throw new XPathException(this.getASTNode(), "err:FORX0004 The value of $replacement contains a '\\' character that is not part of a '\\\\' pair, unless it is immediately followed by a '$' character.");
                    }
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new XPathException(this.getASTNode(), "err:FORX0004 The value of $replacement contains a '\\' character that is not part of a '\\\\' pair, unless it is immediately followed by a '$' character.");
                }
            }
            int flags = 0;
            if (this.getSignature().getArgumentCount() == 4) {
                flags = FunReplace.parseFlags(this.getArgument(3).eval(contextSequence, contextItem).getStringValue());
            }
            try {
                if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                    this.pat = Pattern.compile(pattern, flags);
                    this.matcher = this.pat.matcher(string);
                } else {
                    this.matcher.reset(string);
                }
                String r = this.matcher.replaceAll(replace);
                result = new StringValue(r);
            }
            catch (PatternSyntaxException e) {
                throw new XPathException(this.getASTNode(), "Invalid regular expression: " + e.getMessage(), e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException(this.getASTNode(), "Invalid replace expression: " + e.getMessage(), e);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

