/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class StreamBinary
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("stream-binary", "http://exist-db.org/xquery/response", "response"), "Streams the binary data passed in $a to the current servlet response output stream. The ContentType HTTP header is set to the value given in $b. The filename is set to the value given in $c, if no filename is specified thenthat of the current request is used.This function only works within a servlet context, not within Cocoon. Note: the servlet output stream will be closed afterwards and mime-type settings in the prolog will not be passed.", new SequenceType[]{new SequenceType(26, 2), new SequenceType(22, 2), new SequenceType(22, 3)}, new SequenceType(11, 1), true);
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("stream-binary", "http://exist-db.org/xquery/request", "request"), "Streams the binary data passed in $a to the current servlet response output stream. The ContentType HTTP header is set to the value given in $b. This function only works within a servlet context, not within Cocoon. Note: the servlet output stream will be closed afterwards and mime-type settings in the prolog will not be passed.", new SequenceType[]{new SequenceType(26, 3), new SequenceType(22, 2)}, new SequenceType(11, 1), true, "Renamed to response:stream-binary.");

    public StreamBinary(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ResponseModule myModule;
        Variable respVar;
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Base64Binary binary = (Base64Binary)args[0].itemAt(0);
        String contentType = args[1].getStringValue();
        String filename = null;
        if (args.length > 2 && !args[2].isEmpty()) {
            filename = args[2].getStringValue();
        }
        if ((respVar = (myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response")).resolveVariable(ResponseModule.RESPONSE_VAR)) == null || respVar.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException(this.getASTNode(), signature.toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        response.setHeader("Content-Type", contentType);
        if (filename != null) {
            response.setHeader("Content-Disposition", "inline; filename=" + filename);
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(response.getOutputStream());
            ((OutputStream)os).write(binary.getBinaryData());
            ((OutputStream)os).close();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "IO exception while streaming data: " + e.getMessage(), e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

