/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Timer;
import java.util.TimerTask;
import org.exist.dom.QName;
import org.exist.storage.BrokerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Shutdown
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("shutdown", "http://exist-db.org/xquery/system", "system"), "Shutdown eXist (dba role only).", null, new SequenceType(11, 1)), new FunctionSignature(new QName("shutdown", "http://exist-db.org/xquery/system", "system"), "Shutdown eXist. $a is the delay in milliseconds. (dba role only)", new SequenceType[]{new SequenceType(37, 2)}, new SequenceType(11, 1))};

    public Shutdown(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getUser().hasDbaRole()) {
            long delay = 0L;
            if (args.length == 1 && !args[0].isEmpty()) {
                delay = ((NumericValue)args[0].itemAt(0)).getLong();
            }
            BrokerPool pool = this.context.getBroker().getBrokerPool();
            if (delay > 0L) {
                DelayedShutdownTask task = new DelayedShutdownTask(pool);
                Timer timer = new Timer();
                timer.schedule((TimerTask)task, delay);
            } else {
                pool.shutdown();
            }
        } else {
            throw new XPathException(this.getASTNode(), "Permission denied, calling user '" + this.context.getUser().getName() + "' must be a DBA to shutdown the database");
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private class DelayedShutdownTask
    extends TimerTask {
        private BrokerPool pool = null;

        public DelayedShutdownTask(BrokerPool pool) {
            this.pool = pool;
        }

        public void run() {
            this.pool.shutdown();
        }
    }
}

