/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.RegexTranslator;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class RegexpFilter
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("filter", "http://exist-db.org/xquery/text", "text"), "Filter substrings that match the regular expression $b in text $a.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 7)), new FunctionSignature(new QName("groups", "http://exist-db.org/xquery/text", "text"), "Tries to match the string in $a to the regular expression in $b. Returns an empty sequence if the string does not match, or a sequence whose first item is the entire string, and whose following items are the matched groups.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 7)), new FunctionSignature(new QName("groups", "http://exist-db.org/xquery/text", "text"), "Tries to match the string in $a to the regular expression in $b, using the flags specified in $c. Returns an empty sequence if the string does not match, or a sequence whose first item is the entire string, and whose following items are the matched groups.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 7))};
    private String cachedRegexp = "";
    private Pattern cachedPattern = null;

    public RegexpFilter(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("filter")) {
            return this.filter(args);
        }
        return this.groups(args);
    }

    public Sequence filter(Sequence[] args) throws XPathException {
        if (args.length != 2) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Pattern pattern = null;
        String regexp = args[1].getStringValue();
        if (this.cachedRegexp.equals(regexp) && this.cachedPattern != null) {
            pattern = this.cachedPattern;
        } else {
            this.cachedPattern = pattern = Pattern.compile(regexp);
            this.cachedRegexp = regexp;
        }
        Matcher matcher = pattern.matcher(args[0].getStringValue());
        ValueSequence result = new ValueSequence();
        while (matcher.find()) {
            result.add(new StringValue(matcher.group()));
        }
        return result;
    }

    public Sequence groups(Sequence[] args) throws XPathException {
        Sequence input = args[0];
        Sequence result = input.isEmpty() ? Sequence.EMPTY_SEQUENCE : this.evalGeneric(args, input);
        return result;
    }

    protected String translateRegexp(String pattern) throws XPathException {
        try {
            pattern = RegexTranslator.translate(pattern, true);
        }
        catch (RegexTranslator.RegexSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Conversion from XPath2 to Java regular expression syntax failed: " + e.getMessage(), e);
        }
        return pattern;
    }

    private Sequence evalGeneric(Sequence[] args, Sequence stringArg) throws XPathException {
        String string = stringArg.getStringValue();
        String pattern = this.translateRegexp(args[1].getStringValue());
        int flags = 0;
        if (args.length == 3) {
            flags = RegexpFilter.parseFlags(args[2].getStringValue());
        }
        return this.match(string, pattern, flags);
    }

    private Sequence match(String string, String pattern, int flags) throws XPathException {
        try {
            Matcher matcher;
            if (this.cachedRegexp == null || !this.cachedRegexp.equals(pattern) || flags != this.cachedPattern.flags()) {
                matcher = Pattern.compile(pattern, flags).matcher(string);
                this.cachedPattern = matcher.pattern();
                this.cachedRegexp = string;
            } else {
                matcher = this.cachedPattern.matcher(string);
            }
            if (!matcher.find()) {
                return Sequence.EMPTY_SEQUENCE;
            }
            int items = matcher.groupCount() + 1;
            ValueSequence seq = new ValueSequence();
            seq.add(new StringValue(string));
            for (int i = 1; i < items; ++i) {
                String val = matcher.group(i);
                if (val == null) {
                    val = "";
                }
                seq.add(new StringValue(val));
            }
            return seq;
        }
        catch (PatternSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Invalid regular expression: " + e.getMessage(), e);
        }
    }

    protected static final int parseFlags(String s) throws XPathException {
        int flags = 0;
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                case 'i': {
                    flags = flags | 2 | 0x40;
                    continue block6;
                }
                case 'x': {
                    flags |= 4;
                    continue block6;
                }
                case 's': {
                    flags |= 0x20;
                    continue block6;
                }
                default: {
                    throw new XPathException("Invalid regular expression flag: " + ch);
                }
            }
        }
        return flags;
    }
}

