/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeFunction
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("describe-function", "http://exist-db.org/xquery/util", "util"), "Describes a built-in function. Returns an element describing the function signature.", new SequenceType[]{new SequenceType(24, 2)}, new SequenceType(-1, 2));

    public DescribeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String fname = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        QName qname = QName.parse(this.context, fname, this.context.getDefaultFunctionNamespace());
        String uri = qname.getNamespaceURI();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "name", "name", "CDATA", qname.getStringValue());
        attribs.addAttribute("", "module", "module", "CDATA", uri);
        int nodeNr = builder.startElement("", "function", "function", attribs);
        Module module = this.context.getModule(uri);
        if (module != null) {
            Iterator i = module.getSignaturesForFunction(qname);
            while (i.hasNext()) {
                FunctionSignature signature = (FunctionSignature)i.next();
                this.writeSignature(signature, builder);
            }
        } else {
            Iterator i = this.context.getSignaturesForFunction(qname);
            while (i.hasNext()) {
                FunctionSignature signature = (FunctionSignature)i.next();
                this.writeSignature(signature, builder);
            }
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }

    private void writeSignature(FunctionSignature signature, MemTreeBuilder builder) {
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "arguments", "arguments", "CDATA", Integer.toString(signature.getArgumentCount()));
        builder.startElement("", "prototype", "prototype", attribs);
        attribs.clear();
        builder.startElement("", "signature", "signature", attribs);
        builder.characters(signature.toString());
        builder.endElement();
        if (signature.getDescription() != null) {
            builder.startElement("", "description", "description", attribs);
            builder.characters(signature.getDescription());
            builder.endElement();
        }
        if (signature.getDeprecated() != null) {
            builder.startElement("", "deprecated", "deprecated", attribs);
            builder.characters(signature.getDeprecated());
            builder.endElement();
        }
        builder.endElement();
    }
}

