/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.SimpleTimeZone;
import javax.xml.datatype.Duration;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.memtree.ReferenceNode;
import org.exist.security.PermissionDeniedException;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.source.StringSource;
import org.exist.storage.XQueryPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Eval
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')). The query inherits the current execution context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed.", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("eval", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')). The query inherits the current execution context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed. The third argument specifies if the compiled query expression should be cached. The cached query will be globally available within the db instance.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(23, 2)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("eval-with-context", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')).\nThe query inherits the context described by the XML fragment in the second parameter. It should have the format:\n<static-context>\n\t<output-size-limit value=\"-1\">\n\t<unbind-namespace uri=\"http://exist.sourceforge.net/NS/exist\"/>\n\t<current-dateTime value=\"dateTime\"/>\n\t<implicit-timezone value=\"duration\"/>\n\t<variable name=\"qname\">variable value</variable>\n</static-context>.\nThe third argument specifies if the compiled query expression should be cached. The cached query will be globally available within the db instance.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(-1, 3), new SequenceType(23, 2)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("eval-with-context", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')).\nThe query inherits the context described by the XML fragment in the second parameter. It should have the format:\n<static-context>\n\t<output-size-limit value=\"-1\">\n\t<unbind-namespace uri=\"http://exist.sourceforge.net/NS/exist\"/>\n\t<current-dateTime value=\"dateTime\"/>\n\t<implicit-timezone value=\"duration\"/>\n\t<variable name=\"qname\">variable value</variable>\n</static-context>.\nThe third argument specifies if the compiled query expression should be cached. The cached query will be globally available within the db instance.The fourth argument specifies the context item against which the expression will be evaluated.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(-1, 3), new SequenceType(23, 2), new SequenceType(11, 3)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("eval-inline", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval(xs:anyURI('xmldb:exist:///db/test/test.xq')). The query inherits the first argument's context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(11, 2)}, new SequenceType(11, 7)), new FunctionSignature(new QName("eval-inline", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates an XPath/XQuery expression. If the first argument is of type xs:string, the function tries to execute this string as the query. If the first argument is of type xs:anyURI, the function will try to load the query from the resource to which the URI resolves. If the URI has no scheme, it is assumed that the query is stored in the db and the URI is interpreted as a database path. This is the same as calling util:eval('xmldb:exist:///db/test/test.xq'). The query inherits the first argument's context, i.e. all namespace declarations and variable declarations are visible from within the inner expression. The function returns an empty sequence if a whitespace string is passed.The third argument specifies if the compiled query expression should be cached. The cached query will be globally available within the db instance.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(11, 2), new SequenceType(23, 2)}, new SequenceType(11, 7))};

    public Eval(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        XQueryContext innerContext;
        CompiledXQuery compiled;
        Source querySource;
        Item expr;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        int argCount = 0;
        Sequence exprContext = null;
        if (this.isCalledAs("eval-inline")) {
            exprContext = args[argCount++];
        }
        if (Type.subTypeOf((expr = args[argCount++].itemAt(0)).getType(), 25)) {
            querySource = this.loadQueryFromURI(expr);
        } else {
            String queryStr = expr.getStringValue();
            if ("".equals(queryStr.trim())) {
                return new EmptySequence();
            }
            querySource = new StringSource(queryStr);
        }
        NodeValue contextInit = null;
        if (this.isCalledAs("eval-with-context")) {
            contextInit = (NodeValue)args[argCount++].itemAt(0);
        }
        boolean cache = false;
        if (argCount < this.getArgumentCount()) {
            cache = ((BooleanValue)args[argCount].itemAt(0)).effectiveBooleanValue();
        }
        this.context.pushNamespaceContext();
        LocalVariable mark = this.context.markLocalVariables(false);
        DocumentSet oldDocs = this.context.getStaticallyKnownDocuments();
        if (exprContext != null) {
            this.context.setStaticallyKnownDocuments(exprContext.getDocumentSet());
        }
        if (this.context.isProfilingEnabled(2)) {
            this.context.getProfiler().start(this, "eval: " + expr);
        }
        Sequence sequence = null;
        XQuery xquery = this.context.getBroker().getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiledXQuery = compiled = cache ? pool.borrowCompiledXQuery(this.context.getBroker(), querySource) : null;
        if (contextInit != null) {
            innerContext = xquery.newContext(this.context.getAccessContext());
            this.initContext(contextInit.getNode(), innerContext);
        } else {
            innerContext = this.context.copyContext();
            innerContext.setShared(true);
        }
        try {
            try {
                NodeValue contextItem;
                if (compiled == null) {
                    compiled = xquery.compile(innerContext, querySource);
                } else {
                    compiled.getContext().updateContext(innerContext);
                    compiled.setContext(innerContext);
                }
                if (this.getArgumentCount() == 4 && (contextItem = (NodeValue)args[3].itemAt(0)) != null) {
                    if (exprContext != null) {
                        LOG.warn((Object)"exprContext and contextItem are not null");
                    }
                    exprContext = contextItem.toSequence();
                }
                sequence = xquery.execute(compiled, exprContext, false);
                ValueSequence newSeq = new ValueSequence();
                boolean hasSupplements = false;
                for (int i = 0; i < sequence.getItemCount(); ++i) {
                    if (Type.subTypeOf(sequence.itemAt(i).getType(), 22)) {
                        newSeq.add(new StringValue(((StringValue)sequence.itemAt(i)).getStringValue(true)));
                        hasSupplements = true;
                        continue;
                    }
                    newSeq.add(sequence.itemAt(i));
                }
                if (hasSupplements) {
                    sequence = newSeq;
                }
                Sequence sequence2 = sequence;
                Object var20_23 = null;
                if (innerContext != this.context) {
                    innerContext.reset();
                }
                if (compiled != null) {
                    if (cache) {
                        pool.returnCompiledXQuery(querySource, compiled);
                    } else {
                        compiled.reset();
                    }
                }
                if (oldDocs != null) {
                    this.context.setStaticallyKnownDocuments(oldDocs);
                }
                this.context.popLocalVariables(mark);
                this.context.popNamespaceContext();
                if (!this.context.isProfilingEnabled(2)) return sequence2;
                this.context.getProfiler().end(this, "eval: " + expr, sequence);
                return sequence2;
            }
            catch (XPathException e) {
                try {
                    e.prependMessage("Error while evaluating expression: " + querySource.getContent() + ". ");
                }
                catch (IOException e1) {
                    // empty catch block
                }
                e.setASTNode(this.getASTNode());
                throw e;
            }
            catch (IOException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (innerContext != this.context) {
                innerContext.reset();
            }
            if (compiled != null) {
                if (cache) {
                    pool.returnCompiledXQuery(querySource, compiled);
                } else {
                    compiled.reset();
                }
            }
            if (oldDocs != null) {
                this.context.setStaticallyKnownDocuments(oldDocs);
            }
            this.context.popLocalVariables(mark);
            this.context.popNamespaceContext();
            if (!this.context.isProfilingEnabled(2)) throw throwable;
            this.context.getProfiler().end(this, "eval: " + expr, sequence);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source loadQueryFromURI(Item expr) throws XPathException, NullPointerException, IllegalArgumentException {
        String location = expr.getStringValue();
        Source querySource = null;
        if (location.indexOf(58) < 0 || location.startsWith("xmldb:")) {
            try {
                XmldbURI locationUri = XmldbURI.xmldbUriFor(location);
                if (location.indexOf("/") < 0 || location.startsWith(".")) {
                    XmldbURI moduleLoadPathUri = XmldbURI.xmldbUriFor(this.context.getModuleLoadPath());
                    locationUri = moduleLoadPathUri.resolveCollectionPath(locationUri);
                }
                DocumentImpl sourceDoc = null;
                try {
                    try {
                        sourceDoc = this.context.getBroker().getXMLResource(locationUri.toCollectionPathURI(), 0);
                        if (sourceDoc == null) {
                            throw new XPathException(this.getASTNode(), "source for module " + location + " not found in database");
                        }
                        if (sourceDoc.getResourceType() != 1) throw new XPathException(this.getASTNode(), "source for module " + location + " is not an XQuery or " + "declares a wrong mime-type");
                        if (!sourceDoc.getMetadata().getMimeType().equals("application/xquery")) {
                            throw new XPathException(this.getASTNode(), "source for module " + location + " is not an XQuery or " + "declares a wrong mime-type");
                        }
                        querySource = new DBSource(this.context.getBroker(), (BinaryDocument)sourceDoc, true);
                    }
                    catch (PermissionDeniedException e) {
                        throw new XPathException(this.getASTNode(), "permission denied to read module source from " + location);
                    }
                    Object var8_10 = null;
                    if (sourceDoc == null) return querySource;
                    sourceDoc.getUpdateLock().release(0);
                    return querySource;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (sourceDoc == null) throw throwable;
                    sourceDoc.getUpdateLock().release(0);
                    throw throwable;
                }
            }
            catch (URISyntaxException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
        }
        try {
            return SourceFactory.getSource(this.context.getBroker(), this.context.getModuleLoadPath(), location, true);
        }
        catch (MalformedURLException e) {
            throw new XPathException(this.getASTNode(), "source location for query at " + location + " should be a valid URL: " + e.getMessage());
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "source for query at " + location + " not found: " + e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(this.getASTNode(), "Permission denied to access query at " + location + " : " + e.getMessage());
        }
    }

    private void initContext(Node root, XQueryContext innerContext) throws XPathException {
        NodeList cl = root.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            Element elem;
            Node child = cl.item(i);
            if (child.getNodeType() == 1 && "variable".equals(child.getLocalName())) {
                String type;
                elem = (Element)child;
                String qname = elem.getAttribute("name");
                NodeValue value = (NodeValue)((Object)elem.getFirstChild());
                if (value instanceof ReferenceNode) {
                    value = ((ReferenceNode)value).getReference();
                }
                if ((type = elem.getAttribute("type")) != null && Type.subTypeOf(Type.getType(type), 20)) {
                    innerContext.declareVariable(qname, value.atomize().convertTo(Type.getType(type)));
                    continue;
                }
                innerContext.declareVariable(qname, value);
                continue;
            }
            if (child.getNodeType() == 1 && "output-size-limit".equals(child.getLocalName())) {
                elem = (Element)child;
                innerContext.getWatchDog().setMaxNodes(Integer.valueOf(elem.getAttribute("value")));
                continue;
            }
            if (child.getNodeType() == 1 && "current-dateTime".equals(child.getLocalName())) {
                elem = (Element)child;
                DateTimeValue dtv = new DateTimeValue(elem.getAttribute("value"));
                innerContext.setCalendar(dtv.calendar);
                continue;
            }
            if (child.getNodeType() == 1 && "implicit-timezone".equals(child.getLocalName())) {
                elem = (Element)child;
                Duration duration = TimeUtils.getInstance().newDuration(elem.getAttribute("value"));
                innerContext.setTimeZone(new SimpleTimeZone((int)duration.getTimeInMillis(new Date()), "XQuery context"));
                continue;
            }
            if (child.getNodeType() == 1 && "unbind-namespace".equals(child.getLocalName())) {
                elem = (Element)child;
                if (elem.getAttribute("uri") == null) continue;
                innerContext.removeNamespace(elem.getAttribute("uri"));
                continue;
            }
            if (child.getNodeType() != 1 || !"staticallyKnownDocuments".equals(child.getLocalName())) continue;
            elem = (Element)child;
            NodeValue value = (NodeValue)((Object)elem.getFirstChild());
            if (value instanceof ReferenceNode) {
                value = ((ReferenceNode)value).getReference();
            }
            XmldbURI[] pathes = new XmldbURI[]{XmldbURI.create(value.getStringValue())};
            innerContext.setStaticallyKnownDocuments(pathes);
        }
    }
}

