/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class NodeId
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-id", "http://exist-db.org/xquery/util", "util"), "Returns the internal node-id of a node. The internal node-id uniquely identifies a node within its document. It is encoded as a long number.", new SequenceType[]{new SequenceType(-1, 2)}, new SequenceType(22, 2));

    public NodeId(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue docNode = (NodeValue)args[0].itemAt(0);
        if (docNode.getImplementationType() == 0) {
            throw new XPathException(this.getASTNode(), "First argument to function node-by-id should be a persistent node, not an in-memory node.");
        }
        org.exist.numbering.NodeId nodeId = ((NodeProxy)docNode).getNodeId();
        return new StringValue(nodeId.toString());
    }
}

