/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class PrologFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("import-module", "http://exist-db.org/xquery/util", "util"), "Dynamically imports an XQuery module into the current context. The namespace URI of the module is specified in argument $a, $b is the prefix that will be assigned to that namespace, $c is the location of the module. The parameters have the same meaning as in an 'import module ...' expression in the query prolog.", new SequenceType[]{new SequenceType(25, 2), new SequenceType(22, 2), new SequenceType(25, 2)}, new SequenceType(11, 1)), new FunctionSignature(new QName("declare-namespace", "http://exist-db.org/xquery/util", "util"), "Dynamically declares a namespace/prefix mapping for the current context. The prefix is specified in $a, the namespace URI in $b.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(25, 2)}, new SequenceType(11, 1)), new FunctionSignature(new QName("declare-option", "http://exist-db.org/xquery/util", "util"), "Dynamically declares a serialization option as with 'declare option'.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(11, 1))};

    public PrologFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("declare-namespace")) {
            this.declareNamespace(args);
        } else if (this.isCalledAs("declare-option")) {
            this.declareOption(args);
        } else {
            this.importModule(args);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private void declareNamespace(Sequence[] args) throws XPathException {
        String prefix = args[0].isEmpty() ? "" : args[0].getStringValue();
        String uri = args[1].getStringValue();
        this.context.declareNamespace(prefix, uri);
    }

    private void importModule(Sequence[] args) throws XPathException {
        String uri = args[0].getStringValue();
        String prefix = args[1].getStringValue();
        String location = args[2].getStringValue();
        this.context.importModule(uri, prefix, location);
    }

    private void declareOption(Sequence[] args) throws XPathException {
        String qname = args[0].getStringValue();
        String options = args[1].getStringValue();
        this.context.addOption(qname, options);
    }
}

