/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.collections.Collection;
import org.exist.dom.NodeProxy;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.XMLDBException;

public abstract class XMLDBAbstractCollectionManipulator
extends BasicFunction {
    private final boolean errorIfAbsent;

    public XMLDBAbstractCollectionManipulator(XQueryContext context, FunctionSignature signature) {
        this(context, signature, true);
    }

    public XMLDBAbstractCollectionManipulator(XQueryContext context, FunctionSignature signature, boolean errorIfAbsent) {
        super(context, signature);
        this.errorIfAbsent = errorIfAbsent;
    }

    protected LocalCollection createLocalCollection(String name) throws XMLDBException {
        try {
            return new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), new AnyURIValue(name).toXmldbURI(), this.context.getAccessContext());
        }
        catch (XPathException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (0 == args.length) {
            throw new XPathException(this.getASTNode(), "Expected a collection as the first argument.");
        }
        boolean collectionNeedsClose = false;
        LocalCollection collection = null;
        Item item = args[0].itemAt(0);
        if (Type.subTypeOf(item.getType(), -1)) {
            NodeValue node = (NodeValue)item;
            LOG.debug((Object)"Found node");
            if (node.getImplementationType() != 1) return Sequence.EMPTY_SEQUENCE;
            Collection internalCol = ((NodeProxy)node).getDocument().getCollection();
            LOG.debug((Object)"Found node");
            try {
                collection = this.createLocalCollection(internalCol.getURI().toString());
                LOG.debug((Object)("Loaded collection " + collection.getName()));
            }
            catch (XMLDBException e) {
                throw new XPathException(this.getASTNode(), "Failed to access collection: " + internalCol.getURI(), e);
            }
        }
        if (collection == null) {
            String collectionURI = args[0].getStringValue();
            if (collectionURI != null) {
                try {
                    collection = !collectionURI.startsWith("xmldb:") ? this.createLocalCollection(collectionURI) : (collectionURI.startsWith("xmldb:exist:///") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://", "")) : (collectionURI.startsWith("xmldb:exist://localhost") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://localhost", "")) : (collectionURI.startsWith("xmldb:exist://127.0.0.1") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://127.0.0.1", "")) : DatabaseManager.getCollection((String)collectionURI))));
                }
                catch (XMLDBException xe) {
                    if (this.errorIfAbsent) {
                        throw new XPathException(this.getASTNode(), "Could not locate collection: " + collectionURI, xe);
                    }
                    collection = null;
                }
            }
            if (collection == null && this.errorIfAbsent) {
                throw new XPathException(this.getASTNode(), "Unable to find collection: " + collectionURI);
            }
        }
        Sequence s = Sequence.EMPTY_SEQUENCE;
        try {
            s = this.evalWithCollection(collection, args, contextSequence);
            Object var10_10 = null;
            if (!collectionNeedsClose) return s;
            if (collection == null) return s;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!collectionNeedsClose || collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), "Unable to close collection", e);
            }
        }
        try {
            collection.close();
            return s;
        }
        catch (Exception e) {
            throw new XPathException(this.getASTNode(), "Unable to close collection", e);
        }
    }

    protected abstract Sequence evalWithCollection(org.xmldb.api.base.Collection var1, Sequence[] var2, Sequence var3) throws XPathException;
}

