/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.Date;
import org.exist.dom.QName;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCreated
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] createdSignatures = new FunctionSignature[]{new FunctionSignature(new QName("created", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the creation date of a resource $b in the collection specified by $a. The collection can be passed as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(50, 2)), new FunctionSignature(new QName("created", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the creation date of a collection $a. The collection can be passed as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(50, 2))};
    public static final FunctionSignature lastModifiedSignature = new FunctionSignature(new QName("last-modified", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the last-modification date of a resource, whose name is specified by $b, in the collection specified by $a. The collection can be passed as a simple collection path or an XMLDB URI.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(50, 3));

    public XMLDBCreated(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Date date;
            if (this.getSignature().getArgumentCount() == 1) {
                date = ((CollectionImpl)collection).getCreationTime();
            } else {
                Resource resource = collection.getResource(args[1].getStringValue());
                if (resource == null) {
                    return Sequence.EMPTY_SEQUENCE;
                }
                date = this.isCalledAs("last-modified") ? ((EXistResource)resource).getLastModificationTime() : ((EXistResource)resource).getCreationTime();
            }
            return new DateTimeValue(date);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Failed to retrieve creation date: " + e.getMessage(), e);
        }
    }
}

