/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.File;
import java.util.StringTokenizer;
import org.exist.dom.QName;
import org.exist.util.DirectoryScanner;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBLoadFromPattern
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store new resources into the database. Resources are read from the server's file system, using file patterns. The first argument denotes the collection where resources should be stored. The collection can be either specified as a simple collection path or an XMLDB URI. The second argument is the directory in the file system wherefrom the files are read.The third argument is the file pattern. File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 6)}, new SequenceType(22, 7)), new FunctionSignature(new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store new resources into the database. Resources are read from the server's file system, using file patterns. The first argument denotes the collection where resources should be stored. The collection can be either specified as a simple collection path or an XMLDB URI. The second argument is the directory in the file system wherefrom the files are read.The third argument is the file pattern. File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one. The fourth argument $d is used to specify a mime-type.  If the mime-type is something other than 'text/xml' or 'application/xml', the resource will be stored as a binary resource.The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 6), new SequenceType(22, 2)}, new SequenceType(22, 7)), new FunctionSignature(new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store new resources into the database. Resources are read from the server's file system, using file patterns. The first argument denotes the collection where resources should be stored. The collection can be either specified as a simple collection path or an XMLDB URI. The second argument is the directory in the file system wherefrom the files are read.The third argument is the file pattern. File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one. The fourth argument $d is used to specify a mime-type.  If the mime-type is something other than 'text/xml' or 'application/xml', the resource will be stored as a binary resource.If the final boolean argument is true(), the directory structure will be kept in the collection, otherwise all the matching resources, including the ones in sub-directories, will be stored in the collection given in the first argument flatly.The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 6), new SequenceType(22, 2), new SequenceType(23, 2)}, new SequenceType(22, 7))};

    public XMLDBLoadFromPattern(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        File baseDir = new File(args[1].getStringValue());
        LOG.debug((Object)("Loading files from directory: " + baseDir));
        Sequence patterns = args[2];
        String resourceType = "XMLResource";
        String mimeType = MimeType.XML_TYPE.getName();
        boolean keepDirStructure = false;
        if (this.getSignature().getArgumentCount() > 3) {
            mimeType = args[3].getStringValue();
            MimeType mime = MimeTable.getInstance().getContentType(mimeType);
            if (mime != null && !mime.isXMLType()) {
                resourceType = "BinaryResource";
            }
        }
        if (this.getSignature().getArgumentCount() == 5) {
            keepDirStructure = args[4].effectiveBooleanValue();
        }
        ValueSequence stored = new ValueSequence();
        SequenceIterator i = patterns.iterate();
        while (i.hasNext()) {
            String pattern = i.nextItem().getStringValue();
            File[] files = DirectoryScanner.scanDir(baseDir, pattern);
            LOG.debug((Object)("Found: " + files.length));
            Collection col = collection;
            String prevDir = null;
            for (int j = 0; j < files.length; ++j) {
                try {
                    LOG.debug((Object)files[j].getAbsolutePath());
                    String relPath = files[j].toString().substring(baseDir.toString().length());
                    int p = relPath.lastIndexOf(File.separatorChar);
                    String relDir = relPath.substring(0, p);
                    relDir = relDir.replace(File.separatorChar, '/');
                    if (keepDirStructure && (prevDir == null || !relDir.equals(prevDir))) {
                        col = this.makeColl(collection, relDir);
                        prevDir = relDir;
                    }
                    Resource resource = col.createResource(files[j].getName(), resourceType);
                    resource.setContent((Object)files[j]);
                    if ("BinaryResource".equals(resourceType)) {
                        ((EXistResource)resource).setMimeType(mimeType);
                    }
                    col.storeResource(resource);
                    stored.add(new StringValue(col.getName() + "/" + resource.getId()));
                    continue;
                }
                catch (XMLDBException e) {
                    LOG.warn((Object)("Could not store file " + files[j].getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return stored;
    }

    private final Collection makeColl(Collection parentColl, String relPath) throws XMLDBException {
        Collection current = parentColl;
        StringTokenizer tok = new StringTokenizer(relPath, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            Collection c = current.getChildCollection(token);
            if (c == null) {
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                current = mgtService.createCollection(token);
                continue;
            }
            current = c;
        }
        return current;
    }
}

