/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.SAXException;

public abstract class Modification
extends AbstractExpression {
    protected static final Logger LOG = Logger.getLogger((Class)Modification.class);
    protected final Expression select;
    protected final Expression value;
    protected DocumentSet lockedDocuments = null;
    protected DocumentSet modifiedDocuments = new DocumentSet();
    protected Int2ObjectHashMap triggers;

    public Modification(XQueryContext context, Expression select, Expression value) {
        super(context);
        this.select = select;
        this.value = value;
        this.triggers = new Int2ObjectHashMap(97);
    }

    public int getCardinality() {
        return 1;
    }

    public int returnsType() {
        return 10;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.select.resetState(postOptimization);
        if (this.value != null) {
            this.value.resetState(postOptimization);
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        contextInfo.addFlag(8);
        this.select.analyze(contextInfo);
        if (this.value != null) {
            this.value.analyze(contextInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredNode[] selectAndLock(Txn transaction, NodeSet nodes) throws LockException, PermissionDeniedException, XPathException {
        Lock globalLock = this.context.getBroker().getBrokerPool().getGlobalUpdateLock();
        try {
            globalLock.acquire(0);
            this.lockedDocuments = nodes.getDocumentSet();
            this.lockedDocuments.lock(this.context.getBroker(), true, false);
            StoredNode[] ql = new StoredNode[nodes.getLength()];
            for (int i = 0; i < ql.length; ++i) {
                ql[i] = (StoredNode)nodes.item(i);
                DocumentImpl doc = (DocumentImpl)ql[i].getOwnerDocument();
                this.prepareTrigger(transaction, doc);
            }
            StoredNode[] storedNodeArray = ql;
            return storedNodeArray;
        }
        finally {
            globalLock.release(0);
        }
    }

    protected Sequence deepCopy(Sequence inSeq) throws XPathException {
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.setReceiver(receiver);
        try {
            ValueSequence out = new ValueSequence();
            SequenceIterator i = inSeq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                if (Type.subTypeOf(item.getType(), -1)) {
                    if (((NodeValue)item).getImplementationType() == 1) {
                        int last = builder.getDocument().getLastNode();
                        NodeProxy p = (NodeProxy)item;
                        serializer.toReceiver(p, false, false);
                        item = p.getNodeType() == 2 ? builder.getDocument().getLastAttr() : builder.getDocument().getNode(last + 1);
                    } else {
                        ((NodeImpl)item).deepCopy();
                    }
                }
                out.add(item);
            }
            ValueSequence valueSequence = out;
            return valueSequence;
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), e.getMessage(), e);
        }
        finally {
            this.context.popDocumentContext();
        }
    }

    protected void finishTriggers(Txn transaction) {
        Iterator iterator = this.modifiedDocuments.iterator();
        while (iterator.hasNext()) {
            DocumentImpl doc = (DocumentImpl)iterator.next();
            this.context.addModifiedDoc(doc);
            this.finishTrigger(transaction, doc);
        }
        this.triggers.clear();
    }

    protected void unlockDocuments() {
        if (this.lockedDocuments == null) {
            return;
        }
        this.modifiedDocuments.clear();
        this.lockedDocuments.unlock(true);
        this.lockedDocuments = null;
    }

    public static void checkFragmentation(XQueryContext context, DocumentSet docs) throws EXistException {
        int fragmentationLimit = -1;
        Object property = context.getBroker().getBrokerPool().getConfiguration().getProperty("xupdate.fragmentation");
        if (property != null) {
            fragmentationLimit = (Integer)property;
        }
        Modification.checkFragmentation(context, docs, fragmentationLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFragmentation(XQueryContext context, DocumentSet docs, int splitCount) throws EXistException {
        DBBroker broker = context.getBroker();
        TransactionManager txnMgr = context.getBroker().getBrokerPool().getTransactionManager();
        Txn transaction = context.getBatchTransaction();
        if (transaction == null) {
            transaction = txnMgr.beginTransaction();
        }
        try {
            Iterator i = docs.iterator();
            while (i.hasNext()) {
                DocumentImpl next = (DocumentImpl)i.next();
                if (next.getMetadata().getSplitCount() > splitCount) {
                    try {
                        next.getUpdateLock().acquire(1);
                        broker.defragXMLResource(transaction, next);
                    }
                    finally {
                        next.getUpdateLock().release(1);
                    }
                }
                broker.checkXMLResourceConsistency(next);
            }
            if (!context.hasBatchTransaction()) {
                txnMgr.commit(transaction);
            }
        }
        catch (Exception e) {
            txnMgr.abort(transaction);
        }
    }

    private void prepareTrigger(Txn transaction, DocumentImpl doc) {
        if (this.context.hasBatchTransaction()) {
            Iterator itTrigDoc = this.modifiedDocuments.iterator();
            while (itTrigDoc.hasNext()) {
                DocumentImpl trigDoc = (DocumentImpl)itTrigDoc.next();
                if (!trigDoc.getURI().equals(doc.getURI())) continue;
                return;
            }
        }
        CollectionConfiguration config = doc.getCollection().getConfiguration(this.context.getBroker());
        DocumentTrigger trigger = null;
        if (config != null) {
            try {
                trigger = (DocumentTrigger)config.newTrigger(1, this.context.getBroker(), doc.getCollection());
            }
            catch (CollectionConfigurationException e) {
                LOG.debug((Object)("An error occurred while initializing a trigger for collection " + doc.getCollection().getURI() + ": " + e.getMessage()), (Throwable)e);
            }
            if (trigger != null) {
                try {
                    trigger.prepare(1, this.context.getBroker(), transaction, doc.getURI(), doc);
                }
                catch (TriggerException te) {
                    LOG.debug((Object)("Unable to prepare trigger for event UPDATE_DOCUMENT_EVENT: " + te.getMessage()));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Trigger event UPDATE_DOCUMENT_EVENT for collection: " + doc.getCollection().getURI() + " with: " + doc.getURI() + " " + e.getMessage()));
                }
                this.triggers.put(doc.getDocId(), trigger);
            }
        }
    }

    private void finishTrigger(Txn transaction, DocumentImpl doc) {
        if (this.context.hasBatchTransaction()) {
            this.context.setBatchTransactionTrigger(doc);
        } else {
            DocumentTrigger trigger = (DocumentTrigger)this.triggers.get(doc.getDocId());
            if (trigger != null) {
                try {
                    trigger.finish(1, this.context.getBroker(), transaction, doc.getURI(), doc);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Trigger event UPDATE_DOCUMENT_EVENT for collection: " + doc.getCollection().getURI() + " with: " + doc.getURI() + " " + e.getMessage()));
                }
            }
        }
    }

    public Txn getTransaction() {
        Txn transaction = this.context.getBatchTransaction();
        if (transaction == null) {
            TransactionManager txnMgr = this.context.getBroker().getBrokerPool().getTransactionManager();
            transaction = txnMgr.beginTransaction();
        }
        return transaction;
    }

    public void commitTransaction(Txn transaction) throws TransactionException {
        if (!this.context.hasBatchTransaction()) {
            TransactionManager txnMgr = this.context.getBroker().getBrokerPool().getTransactionManager();
            txnMgr.commit(transaction);
        }
    }

    static final class IndexListener
    implements NodeIndexListener {
        StoredNode[] nodes;

        public IndexListener(StoredNode[] nodes) {
            this.nodes = nodes;
        }

        public void nodeChanged(StoredNode node) {
            long address = node.getInternalAddress();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!StorageAddress.equals(this.nodes[i].getInternalAddress(), address)) continue;
                this.nodes[i] = node;
            }
        }
    }
}

