/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;

public abstract class AbstractDateTimeValue
extends ComputableValue {
    public final XMLGregorianCalendar calendar;
    private XMLGregorianCalendar implicitCalendar;
    private XMLGregorianCalendar canonicalCalendar;
    private XMLGregorianCalendar trimmedCalendar;
    protected static Pattern negativeDateStart = Pattern.compile("^\\d\\d?-(\\d+)-(.*)");
    protected static Pattern gYearWUTCTZ = Pattern.compile("^(\\d\\d\\d\\d)([+-])(\\d\\d):(\\d\\d)$");
    protected static Pattern gYearNoTZ = Pattern.compile("^(\\d\\d\\d\\d)$");
    protected static Pattern gDayWTZ = Pattern.compile("^(---\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern gMonthWTZ = Pattern.compile("^(--\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern gYearMonthWTZ = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern gMonthDayWTZ = Pattern.compile("^(--\\d\\d-\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern dateWTZ = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern timeNoTZ = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)");
    protected static Pattern timeWUTCTZ = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)([+-]\\d\\d:\\d\\d)");
    protected static Pattern timeMsWTZ = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)(\\.)(\\d\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern dateTimeMsWTZ = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\dT)(\\d\\d):(\\d\\d):(\\d\\d)(\\.)(\\d\\d\\d)([+-])(\\d\\d):(\\d\\d)");
    protected static Pattern dateTimeNoTZ = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d)(T)(\\d\\d):(\\d\\d):(\\d\\d)");
    protected static Pattern dateInvalidDay = Pattern.compile("^(---)\\d(\\d\\d)");
    protected static Pattern dateInvalidMonth = Pattern.compile("(^\\d\\d\\d\\d-\\d\\d\\d-\\d\\d$|^\\d\\d\\d\\d-\\d\\d\\d.*|^\\d\\d\\d\\d-\\d\\d\\d-\\d\\dT.*)");
    protected static Pattern dateInvalidYear = Pattern.compile("(^0(\\d\\d\\d\\d\\d*)-(\\d\\d)-(\\d\\d)|^0(\\d\\d\\d\\d)-(\\d\\d\\d)|^0(\\d\\d\\d\\d)-(\\d\\d)|^0(\\d\\d\\d\\d)|^0(\\d\\d\\d\\d\\d*)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d))");
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    private static final Duration tzLowerBound = TimeUtils.getInstance().newDurationDayTime("-PT14H");
    private static final Duration tzUpperBound = tzLowerBound.negate();

    protected AbstractDateTimeValue(XMLGregorianCalendar calendar) {
        this.calendar = calendar;
    }

    protected AbstractDateTimeValue(String lexicalValue) throws XPathException {
        lexicalValue = StringValue.trimWhitespace(lexicalValue);
        lexicalValue = AbstractDateTimeValue.normalizeDate(lexicalValue);
        lexicalValue = AbstractDateTimeValue.normalizeTime(lexicalValue);
        try {
            this.calendar = TimeUtils.getInstance().newXMLGregorianCalendar(lexicalValue);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + lexicalValue + "' " + e.getMessage(), (Throwable)e);
        }
    }

    protected XMLGregorianCalendar getImplicitCalendar() {
        if (this.implicitCalendar == null) {
            this.implicitCalendar = (XMLGregorianCalendar)this.calendar.clone();
            if (this.calendar.getTimezone() == Integer.MIN_VALUE) {
                this.implicitCalendar.setTimezone(TimeUtils.getInstance().getLocalTimezoneOffsetMinutes());
            }
            switch (this.getType()) {
                case 51: {
                    this.implicitCalendar.setTime(0, 0, 0);
                    break;
                }
                case 52: {
                    this.implicitCalendar.setYear(1972);
                    this.implicitCalendar.setMonth(12);
                    this.implicitCalendar.setDay(31);
                    break;
                }
            }
            this.implicitCalendar = this.implicitCalendar.normalize();
        }
        return this.implicitCalendar;
    }

    protected XMLGregorianCalendar getCanonicalCalendar() {
        if (this.canonicalCalendar == null) {
            this.canonicalCalendar = this.getTrimmedCalendar().normalize();
        }
        return this.canonicalCalendar;
    }

    protected XMLGregorianCalendar getTrimmedCalendar() {
        if (this.trimmedCalendar == null) {
            this.trimmedCalendar = AbstractDateTimeValue.cloneXMLGregorianCalendar(this.calendar);
            BigDecimal fract = this.trimmedCalendar.getFractionalSecond();
            if (fract != null) {
                int i;
                String s = fract.toString();
                for (i = s.length(); i > 0 && s.charAt(i - 1) == '0'; --i) {
                }
                if (i == 0) {
                    this.trimmedCalendar.setFractionalSecond(null);
                } else if (i != s.length()) {
                    this.trimmedCalendar.setFractionalSecond(new BigDecimal(s.substring(0, i)));
                }
            }
        }
        return this.trimmedCalendar;
    }

    protected abstract AbstractDateTimeValue createSameKind(XMLGregorianCalendar var1) throws XPathException;

    protected long getTimeInMillis() {
        return this.getImplicitCalendar().toGregorianCalendar().getTimeInMillis();
    }

    protected abstract QName getXMLSchemaType();

    public String getStringValue() throws XPathException {
        Matcher m;
        String r = this.getTrimmedCalendar().toXMLFormat();
        boolean startsWithDashDash = r.startsWith("--");
        r = r.replaceAll("--", "");
        if (startsWithDashDash) {
            r = "--" + r;
        }
        if ((m = negativeDateStart.matcher(r)).matches()) {
            int year = Integer.valueOf(m.group(1));
            DecimalFormat df = new DecimalFormat("0000");
            r = "-" + df.format(year) + "-" + m.group(2);
        }
        return r;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("FORG0006: effective boolean value invalid operand type: " + Type.getTypeName(this.getType()));
    }

    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public int getPart(int part) {
        switch (part) {
            case 0: {
                return this.calendar.getYear();
            }
            case 1: {
                return this.calendar.getMonth();
            }
            case 2: {
                return this.calendar.getDay();
            }
            case 3: {
                return this.calendar.getHour();
            }
            case 4: {
                return this.calendar.getMinute();
            }
            case 5: {
                return this.calendar.getSecond();
            }
            case 6: {
                int mSec = this.calendar.getMillisecond();
                if (mSec == Integer.MIN_VALUE) {
                    return 0;
                }
                return this.calendar.getMillisecond();
            }
        }
        throw new IllegalArgumentException("Invalid argument to method getPart");
    }

    protected void validateTimezone(DayTimeDurationValue offset) throws XPathException {
        Duration tz = offset.duration;
        Number secs = tz.getField(DatatypeConstants.SECONDS);
        if (secs != null && ((BigDecimal)secs).compareTo(BigDecimal.valueOf(0L)) != 0) {
            throw new XPathException("duration " + offset + " has fractional minutes so cannot be used as a timezone offset");
        }
        if (!(tz.equals(tzLowerBound) || tz.equals(tzUpperBound) || tz.isLongerThan(tzLowerBound) && tz.isShorterThan(tzUpperBound))) {
            throw new XPathException("duration " + offset + " outside valid timezone offset range");
        }
    }

    public AbstractDateTimeValue adjustedToTimezone(DayTimeDurationValue offset) throws XPathException {
        if (offset == null) {
            offset = new DayTimeDurationValue(TimeUtils.getInstance().getLocalTimezoneOffsetMillis());
        }
        this.validateTimezone(offset);
        XMLGregorianCalendar xgc = (XMLGregorianCalendar)this.calendar.clone();
        if (xgc.getTimezone() != Integer.MIN_VALUE) {
            if (this.getType() == 51) {
                xgc.setTime(0, 0, 0);
            }
            xgc = xgc.normalize();
            xgc.add(offset.duration);
        }
        try {
            xgc.setTimezone((int)(offset.getValue() / 60.0));
        }
        catch (IllegalArgumentException e) {
            throw new XPathException("illegal timezone offset " + offset, (Throwable)e);
        }
        return this.createSameKind(xgc);
    }

    public AbstractDateTimeValue withoutTimezone() throws XPathException {
        XMLGregorianCalendar xgc = (XMLGregorianCalendar)this.calendar.clone();
        xgc.setTimezone(Integer.MIN_VALUE);
        return this.createSameKind(xgc);
    }

    public Sequence getTimezone() throws XPathException {
        int tz = this.calendar.getTimezone();
        if (tz == Integer.MIN_VALUE) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return new DayTimeDurationValue((long)tz * 60000L);
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        int cmp = this.compareTo(collator, other);
        switch (operator) {
            case 4: {
                return cmp == 0;
            }
            case 5: {
                return cmp != 0;
            }
            case 0: {
                return cmp < 0;
            }
            case 3: {
                return cmp <= 0;
            }
            case 1: {
                return cmp > 0;
            }
            case 2: {
                return cmp >= 0;
            }
        }
        throw new XPathException("Unknown operator type in comparison");
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == this.getType()) {
            int r = this.getImplicitCalendar().compare(((AbstractDateTimeValue)other).getImplicitCalendar());
            if (r == 2) {
                throw new RuntimeException("indeterminate order between " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException("Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        AbstractDateTimeValue otherDate = other.getType() == this.getType() ? (AbstractDateTimeValue)other : (AbstractDateTimeValue)other.convertTo(this.getType());
        return this.getImplicitCalendar().compare(otherDate.getImplicitCalendar()) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        AbstractDateTimeValue otherDate = other.getType() == this.getType() ? (AbstractDateTimeValue)other : (AbstractDateTimeValue)other.convertTo(this.getType());
        return this.getImplicitCalendar().compare(otherDate.getImplicitCalendar()) < 0 ? this : other;
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: 
            case 55: {
                return other.plus(this);
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:dayTimeDuration or xdt:yearMonthDuration; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        throw new XPathException("multiplication is not supported for type " + Type.getTypeName(this.getType()));
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        throw new XPathException("division is not supported for type " + Type.getTypeName(this.getType()));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(DateValue.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(XMLGregorianCalendar.class)) {
            return 1;
        }
        if (javaClass.isAssignableFrom(GregorianCalendar.class)) {
            return 2;
        }
        if (javaClass == Date.class) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target == Object.class || target.isAssignableFrom(DateValue.class)) {
            return this;
        }
        if (target.isAssignableFrom(XMLGregorianCalendar.class)) {
            return this.calendar.clone();
        }
        if (target.isAssignableFrom(GregorianCalendar.class)) {
            return this.calendar.toGregorianCalendar();
        }
        if (target == Date.class) {
            return this.calendar.toGregorianCalendar().getTime();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 50)) {
            try {
                return this.calendar.compare(TimeUtils.getInstance().newXMLGregorianCalendar(other.getStringValue()));
            }
            catch (XPathException e) {
                System.out.println("Failed to get string value of '" + other + "'");
                return 1;
            }
        }
        return this.getType() > other.getType() ? 1 : -1;
    }

    public static String normalizeDate(String dateValue) throws XPathException {
        Matcher d = dateInvalidDay.matcher(dateValue);
        Matcher m = dateInvalidMonth.matcher(dateValue);
        Matcher y = dateInvalidYear.matcher(dateValue);
        if (d.matches() || m.matches() || y.matches()) {
            throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + dateValue + "'");
        }
        return dateValue;
    }

    public static String normalizeTime(String timeValue) throws XPathException {
        int hours = 0;
        int mins = 0;
        int secs = 0;
        int mSecs = 0;
        int tzHours = 0;
        int tzMins = 0;
        DecimalFormat df = new DecimalFormat("00");
        DecimalFormat msf = new DecimalFormat("000");
        Matcher m = timeNoTZ.matcher(timeValue);
        if (m.matches()) {
            hours = Integer.valueOf(m.group(1));
            mins = Integer.valueOf(m.group(2));
            secs = Integer.valueOf(m.group(3));
            if (mins >= 60 || mins < 0 || secs >= 60 || secs < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (hours == 24) {
                if (mins == 0) {
                    hours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = df.format(hours) + ":" + df.format(mins) + ":" + df.format(secs);
        }
        if ((m = dateTimeNoTZ.matcher(timeValue)).matches()) {
            String date = m.group(1);
            AbstractDateTimeValue dateValue = null;
            hours = Integer.valueOf(m.group(3));
            mins = Integer.valueOf(m.group(4));
            secs = Integer.valueOf(m.group(5));
            if (mins >= 60 || mins < 0 || secs >= 60 || secs < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (hours == 24) {
                if (mins == 0) {
                    hours = 0;
                    dateValue = (DateValue)new DateValue(date).plus(new DayTimeDurationValue("P1D"));
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = (dateValue == null ? date : dateValue.getStringValue()) + m.group(2) + df.format(hours) + ":" + df.format(mins) + ":" + df.format(secs);
        }
        if ((m = dateTimeMsWTZ.matcher(timeValue)).matches()) {
            hours = Integer.valueOf(m.group(2));
            mins = Integer.valueOf(m.group(3));
            secs = Integer.valueOf(m.group(4));
            mSecs = Integer.valueOf(m.group(6));
            tzHours = Integer.valueOf(m.group(8));
            tzMins = Integer.valueOf(m.group(9));
            if (mins >= 60 || mins < 0 || tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (hours == 24) {
                if (mins == 0) {
                    hours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + df.format(hours) + ":" + df.format(mins) + ":" + df.format(secs) + m.group(5) + msf.format(mSecs) + m.group(7) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = timeMsWTZ.matcher(timeValue)).matches()) {
            hours = Integer.valueOf(m.group(1));
            mins = Integer.valueOf(m.group(2));
            secs = Integer.valueOf(m.group(3));
            mSecs = Integer.valueOf(m.group(5));
            tzHours = Integer.valueOf(m.group(7));
            tzMins = Integer.valueOf(m.group(8));
            if (mins >= 60 || mins < 0 || tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (hours == 24) {
                if (mins == 0) {
                    hours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = df.format(hours) + ":" + df.format(mins) + ":" + df.format(secs) + m.group(4) + msf.format(mSecs) + m.group(6) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = gYearWUTCTZ.matcher(timeValue)).matches()) {
            tzHours = Integer.valueOf(m.group(3));
            tzMins = Integer.valueOf(m.group(4));
            if (tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (tzHours == 24) {
                if (tzMins == 0) {
                    tzHours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = gDayWTZ.matcher(timeValue)).matches()) {
            tzHours = Integer.valueOf(m.group(3));
            tzMins = Integer.valueOf(m.group(4));
            if (tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (tzHours == 24) {
                if (tzMins == 0) {
                    tzHours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = gMonthWTZ.matcher(timeValue)).matches()) {
            tzHours = Integer.valueOf(m.group(3));
            tzMins = Integer.valueOf(m.group(4));
            if (tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (tzHours == 24) {
                if (tzMins == 0) {
                    tzHours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = gYearMonthWTZ.matcher(timeValue)).matches()) {
            tzHours = Integer.valueOf(m.group(3));
            tzMins = Integer.valueOf(m.group(4));
            if (tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (tzHours == 24) {
                if (tzMins == 0) {
                    tzHours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = gMonthDayWTZ.matcher(timeValue)).matches()) {
            tzHours = Integer.valueOf(m.group(3));
            tzMins = Integer.valueOf(m.group(4));
            if (tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (tzHours == 24) {
                if (tzMins == 0) {
                    tzHours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(tzHours) + ":" + df.format(tzMins);
        }
        if ((m = dateWTZ.matcher(timeValue)).matches()) {
            hours = Integer.valueOf(m.group(3));
            mins = Integer.valueOf(m.group(4));
            if (mins >= 60 || mins < 0 || tzMins >= 60 || tzMins < 0) {
                throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'");
            }
            if (hours == 24) {
                if (mins == 0) {
                    hours = 0;
                } else {
                    throw new XPathException("err:FORG0001: illegal lexical form for date-time-like value '" + timeValue + "'. If hours is 24, minutes must be 00.");
                }
            }
            timeValue = m.group(1) + m.group(2) + df.format(hours) + ":" + df.format(mins);
        }
        return timeValue;
    }

    public static XMLGregorianCalendar cloneXMLGregorianCalendar(XMLGregorianCalendar calendar) {
        boolean hacked = false;
        if (calendar.getYear() == 0) {
            calendar.setYear(1);
            hacked = true;
        }
        XMLGregorianCalendar result = (XMLGregorianCalendar)calendar.clone();
        if (hacked) {
            calendar.setYear(0);
            result.setYear(0);
        }
        return result;
    }
}

