/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exist.EXistException;
import org.exist.dom.DocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xupdate.Modification;

public class Conditional
extends Modification {
    private List modifications = new ArrayList(5);

    public Conditional(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    public void addModification(Modification mod) {
        this.modifications.add(mod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException {
        LOG.debug((Object)"Processing xupdate:if ...");
        XQuery xquery = this.broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        StringSource source = new StringSource(this.selectStmt);
        CompiledXQuery compiled = pool.borrowCompiledXQuery(this.broker, source);
        XQueryContext context = compiled == null ? xquery.newContext(this.getAccessContext()) : compiled.getContext();
        context.setStaticallyKnownDocuments(this.docs);
        this.declareNamespaces(context);
        this.declareVariables(context);
        if (compiled == null) {
            try {
                compiled = xquery.compile(context, source);
            }
            catch (IOException e) {
                throw new EXistException("An exception occurred while compiling the query: " + e.getMessage());
            }
        }
        Sequence seq = null;
        try {
            seq = xquery.execute(compiled, null);
        }
        finally {
            pool.returnCompiledXQuery(source, compiled);
        }
        if (seq.effectiveBooleanValue()) {
            long mods = 0L;
            for (int i = 0; i < this.modifications.size(); ++i) {
                mods += ((Modification)this.modifications.get(i)).process(transaction);
                this.broker.flush();
            }
            LOG.debug((Object)(mods + " modifications processed."));
            return mods;
        }
        return 0L;
    }

    public String getName() {
        return "if";
    }
}

